static char rcsid[] = "@(#)$Id: utils.c,v 1.19 2001/06/09 15:34:30 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.19 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Utility routines for ELM

**/

#include "headers.h"
#include "me.h"
#include "s_elm.h"
#include <errno.h>

DEBUG_VAR(Debug,__FILE__,"ELM");

extern int errno;

void create_new_folders()
{
	/* this creates a new folders directory */

	(void) mkdir(folders, 0700);

	(void) elm_chown(folders, userid, groupid);
}

void create_new_elmdir()
{
	/** this routine is just for allowing new users who don't have the
	    old elm files to create a new .elm directory **/

	char source[SLEN];
	elm_sfprintf(source, sizeof source,
		     FRM("%s/.elm"), home);
	(void) mkdir(source, 0700);

	(void) elm_chown( source, userid, groupid);
}


/*
 * The initialize() procedure sets the "xalloc_fail_handler" vector to
 * point here in the event that xmalloc() or friends fail.
 */
/*ARGSUSED*/
void malloc_failed_exit(proc, len)
{
    MoveCursor(elm_LINES,0);
    Raw(OFF);

    /* NOTE:
       Can't use elm_fprintf (or routines of lib/output.c)
       because here also malloc may fail, therefore
       can not use CATGETS macro;
       And can't use catgets because it may have given 
       incorrent format string from catalog ...

       Same problem also with Write_to_screen() on src/curses.c 
       ... perhaps should use WriteRaw() from src/curses.c
    */
    FlushBuffer();

    fprintf(stderr,"\n\nCouldn't malloc %d bytes!!\n\n", len);

    /* SIGDPRINT does not call malloc */

    SIGDPRINT(Debug,1, (&Debug, "Couldn't malloc %d bytes!!\n",len));
    
    panic("PANIC",__FILE__,__LINE__,"malloc_failed_exit",
	  "Out of memory",0);
}

/* Tjis routine is called by panic() */
void emergency_exit(interrupt)
     int interrupt;
{
    /* if interrupt is true we can't call anything which 
     * is not reentrant 
     */

    /** used in dramatic cases when we must leave without altering
	ANYTHING about the system... **/

    int do_cursor = RawState();

    /*
     *	some OS's get extra cont signal, so once this far into the
     *	exit, ignore those signals (Especially Ultrix)
     */

#ifdef SIGTSTP
    signal(SIGTSTP,SIG_IGN);
#endif
#ifdef SIGSTOP
    signal(SIGSTOP,SIG_IGN);
#endif
#ifdef SIGCONT
    signal(SIGCONT,SIG_IGN);
#endif

    if (interrupt)
	SIGDPRINT(Debug,1, (&Debug,  
			    "\nLeaving mailer from signal handler (emergency_exit)\n"));
    
    SIGDPRINT(Debug,1, (&Debug,  
			"\nERROR: Something dreadful is happening!  Taking emergency exit!!\n\n"));
    SIGDPRINT(Debug,1, (&Debug,  
			"  possibly leaving behind the following files;\n"));
    if (current_folder) {
	SIGDPRINT(Debug,1, (&Debug,  
			    "     The mailbox temp file : %s\n", 
			    current_folder->cur_tempfolder));
    }
    
    SIGDPRINT(Debug,1, (&Debug,  
			"     The composition file : %s\n", 
			cur_editfile));
    
	/* softkeys_off(); */

    if (do_cursor) {
	Raw(OFF);
	MoveCursor(elm_LINES, 0);
    }

    /* lib_error is not safe tp be called form signal handler */
    if (!interrupt)
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmEmergencyExitTaken,
			  "\nEmergency exit taken! All temp files intact!\n\n"));
    else
	WriteRaw("\nEmergency exit taken! All temp files intact!\n\n");

#ifdef USE_PGP
    /* Don't put passphrase to core file! */
    pgp_void_passphrase();
#endif

    /* This routine is called by panic() so 
       DO NOT call panic on here ...
    */
	    
    if (interrupt) {
	WriteRaw("\nABORTING...\n");
	abort();
    }

    exit(127);
}

void rm_temps_exit()
{
    int do_cursor = RawState();

/*
 *	some OS's get extra cont signal, so once this far into the
 *	exit, ignore those signals (Especially Ultrix)
 */
#ifdef SIGTSTP
    signal(SIGTSTP,SIG_IGN);
#endif
#ifdef SIGSTOP
    signal(SIGSTOP,SIG_IGN);
#endif
#ifdef SIGCONT
    signal(SIGCONT,SIG_IGN);
#endif

    PutLineX(elm_LINES, 0, 
	     CATGETS(elm_msg_cat, ElmSet, ElmWriteFailedExitingIntact,
		     "\nWrite to temp file failed, exiting leaving mailbox intact!\n\n"));

    SIGDPRINT(Debug,1, (&Debug,   
			"\nrm_temps_exit, deleteing temp files\n"));
    
    /* softkeys_off(); */

    if (cur_editfile[0])
	unlink(cur_editfile); /* editor buffer */

    if (current_folder) {
	close_folder(current_folder,CLOSE_NORMAL);
    }

    close_cached_connections();

    if(do_cursor) {
	MoveCursor(elm_LINES,0);
	NewLine();
	Raw(OFF);
    }

    exit(1);
}

/*ARGSUSED*/
/*VARARGS0*/

void leave(interrupt)
     int interrupt;
{
  int do_cursor = RawState();

  /* if interrupt is true do not call anything which is not re-entrant */  

/*
 *	some OS's get extra cont signal, so once this far into the
 *	exit, ignore those signals (Especially Ultrix)
 */
#ifdef SIGTSTP
	signal(SIGTSTP,SIG_IGN);
#endif
#ifdef SIGCONT
	signal(SIGCONT,SIG_IGN);
#endif

	if (interrupt)
	    SIGDPRINT(Debug,2, (&Debug,  
				"\nLeaving mailer from signal handler (leave)\n"));
	else
	    SIGDPRINT(Debug,2, (&Debug, 
				"\nLeaving mailer normally (leave)\n"));

	/* softkeys_off(); */

	if (cur_editfile[0])
	    unlink(cur_editfile); /* editor buffer */

	if (current_folder) {
	    unlock(interrupt, current_folder);	/* remove lock file if any */
	    
	    if (!interrupt)
		close_folder(current_folder,CLOSE_NORMAL);
	}

	if (!interrupt)
	    close_cached_connections();

	if (do_cursor) {
	    MoveCursor(elm_LINES,0);
	    NewLine();
	    Raw(OFF);
	}

	if (!interrupt)
	    exit(0);
	_exit(0);
}

void silently_exit()
{
    /** This is the same as 'leave', but it doesn't remove any non-pid
	files.  It's used when we notice that we're trying to create a
	temp mail file and one already exists!!
    **/
    int do_cursor = RawState();
	
/*
 *	some OS's get extra cont signal, so once this far into the
 *	exit, ignore those signals (Especially Ultrix)
 */
#ifdef SIGTSTP
    signal(SIGTSTP,SIG_IGN);
#endif
#ifdef SIGSTOP
    signal(SIGSTOP,SIG_IGN);
#endif
#ifdef SIGCONT
    signal(SIGCONT,SIG_IGN);
#endif

    DPRINT(Debug,2, (&Debug, "\nLeaving mailer quietly (silently_exit)\n"));

    /* softkeys_off(); */
    
    if (cur_editfile[0])
	unlink(cur_editfile);

    if (do_cursor) {
	MoveCursor(elm_LINES,0);
	NewLine();
	Raw(OFF);
    }

    if (current_folder)
	unlock (0,current_folder);

    close_cached_connections();
    
    exit(0);
}

/*ARGSUSED0*/

#ifndef REMOVE_AT_LAST
void leave_locked(val)
     int val;	/* not used, placeholder for signal catching! */
{
	/** same as leave routine, but don't disturb lock file **/

        int do_cursor = RawState();

/*
 *	some OS's get extra cont signal, so once this far into the
 *	exit, ignore those signals (Especially Ultrix)
 */
#ifdef SIGTSTP
	signal(SIGTSTP,SIG_IGN);
#endif
#ifdef SIGSTOP
	signal(SIGSTOP,SIG_IGN);
#endif
#ifdef SIGCONT
	signal(SIGCONT,SIG_IGN);
#endif

	SIGDPRINT(Debug,3, (&Debug, 
			    "\nLeaving mailer due to presence of lock file (leave_locked)\n"));

	/* softkeys_off(); */

	if (cur_editfile[0])
	    unlink(cur_editfile); /* editor buffer */

	if (current_folder) {
	  leave_old_folder(current_folder,CLOSE_LEAVE_LOCKED);
	  current_folder = NULL;
	}

	close_cached_connections();

	if (do_cursor) {
	  MoveCursor(elm_LINES,0);
	  NewLine();
	  Raw(OFF);
	}

	exit(0);
}
#endif

int get_page(msg_pointer)
     int msg_pointer;
{
	/** Ensure that 'current' is on the displayed page,
	    returning NEW_PAGE iff the page changed! **/

	register int first_on_page, last_on_page;

	if (headers_per_page == 0)
	  return(SAME_PAGE); /* What else can I do ? */

	first_on_page = (header_page * headers_per_page) + 1;

	last_on_page = first_on_page + headers_per_page - 1;

	if (selected)	/* but what is it on the SCREEN??? */
	  msg_pointer = compute_visible(msg_pointer);

	if (selected && msg_pointer > selected)
	  return(SAME_PAGE);	/* too far - page can't change! */

	if (msg_pointer > last_on_page) {
	  header_page = (int) (msg_pointer-1)/ headers_per_page;
	  return(NEW_PAGE);
	}
	else if (msg_pointer < first_on_page) {
	  header_page = (int) (msg_pointer-1) / headers_per_page;
	  return(NEW_PAGE);
	}
	else
	  return(SAME_PAGE);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

