static char rcsid[] = "@(#)$Id: metapager.c,v 1.24 2001/06/09 15:34:29 hurtta Exp $";

/*****************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.24 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 ****************************************************************************/

#include <errno.h>
#include "headers.h"
#include "s_elm.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"ui");

extern int errno;

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}

void PressAnyKeyToContinue()
{
    Raw(ON | NO_TITE);
 redraw:
    PutLineX(elm_LINES, 0, 
	     CATGETS(elm_msg_cat, ElmSet, ElmMetaPagePressAnyKey,
		     "Press any key to continue..."));
    if (ReadCh(REDRAW_MARK) == REDRAW_MARK)
	goto redraw;
    Raw(OFF | NO_TITE);
    printf("\n\r");
}

static void this_message P_((out_state_t *buffer, int *inf));

static void this_message(buffer,inf)
     out_state_t *buffer; 
     int *inf;
{

    if (!*inf)
	state_printf(buffer,CATGETS(elm_msg_cat, ElmSet, 
				     ElmThisMessage,
				     "(** This message "));
    else
	state_printf(buffer,CATGETS(elm_msg_cat, ElmSet, 
				     ElmCommaAnd,
				     ", and "));

    (*inf)++;
}

int metapager (fp, hdr, do_headers)
     FILE *fp;
     struct header_rec *hdr;
     int do_headers;
{

    int wait_ret, fork_ret, builtin = 0, status, len;
    int ch = 0;
    char buf[VERY_LONG_STRING];
    FILE                * fpout = NULL;   /* Buffer for external pager */
    struct stringbuffer * bout  = NULL;   /* Buffer for internal pager */
    out_state_t           buffer;         /* General handle for both   */
    
    int err;				/* place holder for errno */
    char tempfile[STRING];
    charset_t  charset_vector[255];

    /* check to see if we want the internal pager */
    if (strincmp(pager, "builtin", 7) == 0 ||
	strincmp(pager, "internal", 8) == 0 ||
	(builtin_lines < 0 
	 ? hdr->lines < elm_LINES + builtin_lines 
	 : hdr->lines < builtin_lines)) {
	
	builtin++;
    }
    
    if (!builtin) {
	elm_sfprintf (tempfile, sizeof tempfile,
		      FRM("%selm.%d"), temp_dir, getpid());
	
	unlink(tempfile);
	fpout = safeopen_rdwr(tempfile);
	unlink(tempfile); /* We can now unlink tempfile ... So nobody
			   * sees data easily (and O_EXCL should prevent
			   * evil playings with symlinks) ...
			   */
	if (!fpout) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPagerFailedTmpFile,
			      "Failed to create temporary file!"));
	    return 0;
	}
	
	out_state_clear(&buffer,STATE_out_file);
	set_out_state_file(fpout,&buffer);


	/* For external pager we use system charset for display */
	charset_vector[0] = system_charset; 
	charset_vector[1] = NULL; 
	buffer.display_charset = charset_vector; 
						  	
	DPRINT(Debug,9, (&Debug, 
			 "metapager(): using tempfile %s\n", tempfile));
    } else {
	if (hdr -> content_length > 8000) {
	    bout = create_filebuffer();
	    DPRINT(Debug,1,(&Debug,   
			    "metapager(): using stringbuffer (possibly file based)\n"));
	} else {
	    bout = create_membuffer();
	    DPRINT(Debug,1,(&Debug,   
			    "metapager(): using stringbuffer\n"));
	}
	out_state_clear(&buffer,STATE_out_buffer);

	/* Internal pager uses display_charset ... */
	buffer.display_charset = 
	    give_display_charsets(charset_vector,
				  sizeof charset_vector / 
				  sizeof (charset_vector[0]));

	set_out_state_sbuffer (bout,&buffer);	
    }
        
    if (fseek (fp, hdr->offset, SEEK_SET) == -1) {
	err = errno;
	DPRINT(Debug,1,(&Debug,   
			"Error: seek %d bytes into file, errno %s (show_message)\n",
			hdr->offset, error_description(err)));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSeekFailedFile,
			  "ELM [seek] couldn't read %d bytes into file (%s)."),
		  hdr->offset, error_description(err));	
	
	out_state_destroy(&buffer);
	if (!builtin)
	    fclose(fpout);
	else
	    free_stringbuffer(&bout);
	
	return (0);
    }
    
  /* this is only true if metapager() is not called from ViewAttachment() */
    if (do_headers) {
	header_list_ptr all_hdrs = NULL, last_hdr = NULL;
	int in_envelope = 1;
	    
	if (title_messages) {
	    int addempty = 0;
	    char buf2[STRING];
	    struct addr_item *p;
	    /* first print a title line */
	    int l1, inf = 0;

	    if (hdr->status & DELETED)
		l1 = state_printf(&buffer, 
				  CATGETS(elm_msg_cat, ElmSet, 
					  ElmPagerStatDeleted,
					  "[Deleted] %d/%d "),
				  current,
				  message_count);
	    else
		l1 = state_printf(&buffer,
				  CATGETS(elm_msg_cat, ElmSet, 
					  ElmPagerStatMessage,
					  "Message %d/%d "),
				  current,
				  message_count);

	    elm_date_str(buf2, hdr->time_sent + hdr->tz_offset, sizeof buf2);
	    strfcat(buf2, " ", sizeof buf2);
	    strfcat(buf2, hdr->time_zone, sizeof buf2);
	    len = elm_COLUMNS - 2 - l1 - strlen(buf2);

	    if (hdr->from) {
		struct string * buf4 = new_string(buffer.display_charset[0]);

		for (p = hdr->from; p->addr && p->fullname; p++) {
		    int left = len-string_len(buf4)-4;
		    struct string * s = NULL;
		    struct string * s1 = NULL;
		    int X = 0;
		    
		    if (string_len(p->fullname)) {
			/* Use convert_string instead of dup_string so 
			 * that text with unknown charset is printed
			 * as [?charset?]
			 */
			s = convert_string(buffer.display_charset[0],
					   p->fullname,1);
		    } else
			s = new_string2(buffer.display_charset[0],
					s2us(p->addr));
		    
		    if (left < 4) {
			free_string(&s);
			break;
		    }
		    if (string_len(buf4) > 0) {
			add_ascii_to_string(buf4,s2us(", "));
			left = len-string_len(buf4)-4;
		    }
		    s1 = clip_from_string(s,&X,left);	      
		    free_string(&s);
		    s = cat_strings(buf4,s1,1);
		    free_string(&buf4);
		    buf4 = s;
		    free_string(&s1);
		    
		    if (string_len(buf4) >= len-4) {
			add_ascii_to_string(buf4,s2us("..."));
			break;
		    }
		}

		state_printf(&buffer,
			     FRM("%-*.*S %s"),
			     len,
			     len,
			     buf4,
			     buf2);
		free_string(&buf4);
	    } else if (len > 10)
		state_printf(&buffer,
			     FRM("(env) %-*.*s %s"),
			     len-7,
			     len-7,
			     hdr->env_from,
			     buf2);

	    /** Print the subject line centered if there is enough room **/
	    if ((len = string_len(hdr->subject)) > 0 && 
		matches_weedlist("subject:")) {
		len = (elm_COLUMNS-len)/2;
		if (len < 0)
		    len = 0;

		state_printf(&buffer,
			     FRM("%*.*s%S"),
			     len,len,"",hdr->subject);
		addempty++;
	    }
      
	    state_putc('\n',&buffer);
		
      
	    /* now some information about this message */
      
	    if (hdr->status & EXPIRED) {
		this_message(&buffer,&inf);
		state_printf(&buffer,CATGETS(elm_msg_cat, ElmSet, 
					     ElmHasExpired,
					     "has EXPIRED"));
	    }
	    if (hdr->status & CONFIDENTIAL) {
		this_message(&buffer,&inf);
		state_printf(&buffer,CATGETS(elm_msg_cat, ElmSet, 
					     ElmTaggedConfidential,
					     "is tagged CONFIDENTIAL"));
	    }      
	    if (hdr->status & URGENT) {
		this_message(&buffer,&inf);
		state_printf(&buffer,CATGETS(elm_msg_cat, ElmSet, 
					     ElmTaggedUrgent,
					     "is tagged URGENT"));
	    }
	    if (hdr->status & PRIVATE_MAIL) {
		this_message(&buffer,&inf);
		state_printf(&buffer,CATGETS(elm_msg_cat, ElmSet, 
					     ElmTaggedPrivate,
					     "is tagged PRIVATE"));
	    }
	    if (inf) {
		state_puts(" **)\n", &buffer);
		addempty++;
	    }
	    
	    if (addempty)
		state_putc('\n',&buffer);
	}

	/** Now do the headers. **/
	
	buffer.filter = display_charset;    /* HACK -- rfc1522_decode*
					       uses display_charset
					     */

	/* read_header_line with flag = 1 (RHL_MARK_FOLDING)
	 * terminates header with \n and marks folding with \n
	 */
	while (0 < read_header_line (fp, buf, VERY_LONG_STRING,
				     RHL_MARK_FOLDING)) {

	    /* read_header_line with flag = 1 (RHL_MARK_FOLDING)
	     * returns \n on EOF
	     */
	    if (0 == strcmp(buf,"\n"))
		break;

	    if (in_envelope) {
#ifdef MMDF
		if (strcmp (buf, MSG_SEPARATOR) == 0)
		    continue;
#endif

		if (0 == strncmp(buf,"From ",5)) {
		    in_envelope = 2;
		} else if (2 == in_envelope && 
			   first_word_nc(buf, ">From")) {
		    /* OK */
		} else {
		    DPRINT(Debug,12,(&Debug,   
				     " .... Leaving envelope part: %s\n",
				     buf));
		    in_envelope = 0;
		    goto not_in_envelope;
		}
		
		if (elm_filter && matches_weedlist(buf))
		    continue;
		
		state_puts(buf, &buffer);

	    }
	    else { 
		char *ptr; 

	    not_in_envelope:
		ptr  = strchr(buf,':');
		if (ptr) {		
		    *ptr = '\0';
		    ptr++;
		    
		    /* Only skip first whitespace for display purposes ... */
		    if (whitespace(*ptr))
			ptr++;		    
		    update_header_list(&all_hdrs, &last_hdr, buf, ptr);
		} else {
		    DPRINT(Debug,12,(&Debug,   
				     " .... not a header: '%s' (update_header_list not called\n",
			    buf));
		}
	    }
	}

	state_write_headers(&buffer,all_hdrs,
			    rfc822_header_filter,
			    elm_filter,			    
			    !(hdr -> status & NOHDRENCODING),
			    hdr->header_charset
			    );
	
	buffer.filter = NULL;   /* End HACK */
	state_putc('\n',&buffer);
	
	delete_headers(&all_hdrs);
    }

    /* Now this does decoding of MIME and PGP --
       copy_body assumes that headers are already readed
    */
    copy_body(fp,hdr,
	      "",&buffer,CM_REMOVE_HEADER|CM_DECODE|CM_DISPLAYING);
    
    out_state_destroy(&buffer);
    if (!builtin)
	rewind(fpout);
    clear_error();
    
    /** Now run the pager! **/
    
    if (builtin) {
	ch = builtinplusplus (bout);
	free_stringbuffer(&bout);
	return (ch);
    }
    
    /** The rest of the code is for an external pager. **/
    Raw(OFF); /* Raw(OFF) must do in parent.... 
	       * Or otherwise in Raw(ON) does not
	       * have effect (because Raw (ON /OFF) 
	       * does nothing if it thinks that mode is
	       * already correct)
	       */
    
    if ((fork_ret = fork()) == -1) {
	err = errno;
	DPRINT(Debug,1,(&Debug,    
			"Error: fork failed, errno %s (metapager)\n",
		   error_description(err)));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPreparePagerFork,
			  "Could not prepare for external pager(fork()-%s)."),
		  error_description(err));	
	PressAnyKeyToContinue();
	Raw (ON);
	fclose(fpout);
	return (0);
    } else if (fork_ret == 0) {
	/* child fork */
	
	/* Direct our temporary file to standard input of child.
	 * Because we immediately unlinked it (for security reasons) 
	 * after creating we don't have name for it and
	 * we can't use < in system_call
	 */
	
	if (dup2 (fileno(fpout),0) == -1) {
	    err = errno;
	    DPRINT(Debug,1,(&Debug,   
			    "Error: dup failed, errno %s (metapager)\n",
			    error_description(err)));	
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPreparePagerDup,
			      "Could not prepare for external pager(dup()-%s)."),
		      error_description(err));	
	    _exit(err);	
	}
	
	fclose(fpout);
	clear_error();
	ClearScreen();
	
	/* now execute pager and exit */
	
	/* system_call() will return user to user's normal permissions. */
	_exit(system_call(pager, SY_ENAB_SIGINT));
    }
    
    fclose (fpout);
    
    while (((wait_ret = wait (&status)) != fork_ret && wait_ret != -1)
	   /* Handle possible signals ... */	 
	   || (wait_ret == -1 && errno == EINTR))
	;

    /* turn raw on **after** child terminates in case child
     * doesn't put us back to cooked mode after we return ourselves to
     * raw. In that point we don't want output ti yet...
     */
    Raw(ON | NO_TITE);
    
    if (prompt_after_pager) {
	StartBold ();
	PutLineX(elm_LINES, 0, 
		 CATGETS(elm_msg_cat, ElmSet, 
			 ElmCommandIToReturn,
			 " Command ('i' to return to index): "));
	EndBold ();
	FlushBuffer();
	ch = ReadCh('i' | READCH_CURSOR);
    }
    else
	ch = 0;
    
    /* This is necessary so that that ti is outputted
     * after te that was caused on Raw(OFF) before pager.
     */
    Raw(OFF | NO_TITE);
    Raw(ON);

  return (ch == 'i' || ch == 'q' ? 0 : ch);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */


