static char rcsid[] = "@(#)$Id: pop.c,v 1.19 2001/06/09 19:37:19 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.19 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "elmtls.h"

DEBUG_VAR(Debug,__FILE__,"tls");


#ifdef ANSI_C
static pop_capa_handler pop_STLS_handler;
#endif
static int pop_STLS_handler(folder,capa,capa_args,fi_size,commands,cb_size,
			    service_config,sc_size,phase)
     struct folder_info *folder;
     char *capa;
     char *capa_args;
     size_t fi_size;
     struct pop_callbacks *commands;
     size_t cb_size;
     struct SE_option   *service_config;
     size_t sc_size;
     enum CAPA_phase *phase;
{
    union stream_types T;   
    int bits;

    int ret = 1;
    int tls = 1;
    char * M = NULL;


    if (fi_size != sizeof (*folder)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:pop_STLS_handler: sizeof (struct folder_info)) = %d != %d\n",
			sizeof (*folder),fi_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (cb_size != sizeof (*commands)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:pop_STLS_handler: sizeof (struct pop_callbacks)) = %d != %d\n",
			sizeof (*commands),cb_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (sc_size != sizeof (*service_config)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:pop_STLS_handler: sizeof (struct struct SE_option)) = %d != %d\n",
			sizeof (*service_config),sc_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }


    if (folder->folder_type != &pop_mbx &&
	NULL == folder -> p) {
	DPRINT(Debug,1,(&Debug,			    
			 "tls:pop_STLS_handler: folder not pop mailbox?\n"));
	goto fail;
    }

    if (!tls_init(1  /* Initalize random also */)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:pop_STLS_handler: Initialization failed\n"));
	goto fail;
    }

    StreamInfo(folder -> p->a.pop_mbx.C.stream,SS_ssf,&bits,NULL);
    if (bits > 0) {
	DPRINT(Debug,4,(&Debug,			    
			"tls:pop_STLS_handler: Already %d 'bits' encryption -- TLS already active?\n",
			bits));
	goto fail;
    }

    if (service_config) {
	if (service_config->type != &tls_options ||
	    !service_config->value) {
	    panic("TLS PANIC",__FILE__,__LINE__,"pop_STLS_handler",
		  "Bad option storage",0);
	}

	if (tls_none == service_config->value->v_starttls) {
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:pop_STLS_handler: tls disabled\n"));
	    goto fail;
	}
	    

	tls = service_config->value->v_starttls;
    }



    if (!commands->push_command(folder,"STLS",1)) {
	commands->clear_command(folder);
	goto fail;            /* Just fail ... */
    }
    if (!commands->command_ok(folder)) {
	commands->clear_command(folder);
	goto fail;            /* Just fail .... */
    }

    commands->clear_command(folder);

    /* After that we need need return failure if something
       goes wrong because connection is messed beyond repair
     */

    T = create_TLS_stream(tls);
    if (T.TYPE == NULL) {
	/* Error message ? */
	ret = 0;
	goto fail;
    }

    /* Message ????? */
    lib_transient(FRM("POP/%s connect to %s ..."),
		  tls ? "TLS" : "SSL",
		  folder -> p->a.pop_mbx.C.host);


    add_stream_to_head(folder -> p->a.pop_mbx.C.stream,
		       T);

    /* We are head on stream */  

    /* Do handshake */
    while (tls_not_connected == 
	   ss_TLS_state(folder -> p->a.pop_mbx.C.stream,0)) {
	WaitStreamFor(folder -> p->a.pop_mbx.C.stream,
		      SS_setup_act);
	M =  RemoveStreamError(folder -> p->a.pop_mbx.C.stream);
	if (M)
	    goto error_jump;
    }

    switch(ss_TLS_state(folder -> p->a.pop_mbx.C.stream,0)) {
    
    default: error_jump:

	if (M) {
	    /* Error message ? */
	    lib_error(FRM("%s"),
		      M);
	    free(M);
	    M = NULL;
	} else {
	    /* Error message ? */
	    lib_error(FRM("POP/%s connect to %s ... Fail"),
		      tls ? "TLS" : "SSL",
		      folder -> p->a.pop_mbx.C.host);
	}

	/* We fail hard now if connection is not OK ... */
	ret = 0;
	goto fail;

    case tls_connected:
	/* Message ????? */
	lib_error(FRM("POP/%s connect to %s ... Done (not verified)"),
		  tls ? "TLS" : "SSL",
		  folder -> p->a.pop_mbx.C.host);
	if (sleepmsg)
	    wait_for_timeout(sleepmsg);

	/* Need retry CAPA command */
	if (capa_prelogin == *phase)
	    *phase = capa_prelogin_again;
    }

 fail:
    return ret;
}

static struct provides_shared_POP_CAPA LIST[] = {
    { "STLS",  1,  pop_STLS_handler },

};

#ifdef ANSI_C
provides_shared_POP_CAPA_f provides_shared_POP_CAPA;
#endif
struct provides_shared_POP_CAPA * provides_shared_POP_CAPA(count,s_size)
     int *count; 
     size_t *s_size;
{
    *s_size = sizeof (struct provides_shared_POP_CAPA);

    *count = (sizeof LIST) / *s_size;

    return &(LIST[0]);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
