
/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

struct sb_in_file {
    char * filename;
    FILE * fh;
    int offset_count;
    long * offsets;
};

struct sb_in_mem {
    int              string_count;
    struct string ** strings;
};

struct sb_private_data {
    union {
	struct sb_in_file   file;
	struct sb_in_mem    mem;
    } a;
};

typedef int  sb_init_buffer P_((struct stringbuffer *buffer));
typedef void sb_free_buffer P_((struct stringbuffer *buffer));
typedef void sb_add_line_to_stringbuffer P_((struct stringbuffer *buffer,
					     const struct string *string));
typedef int sb_linecount_stringbuffer P_((const struct stringbuffer *ptr));
typedef struct string *sb_get_line_from_stringbuffer P_((const struct 
							 stringbuffer *buffer,
							 int ptr));

struct sb_type {
    sb_init_buffer                * sb_init_it;
    sb_free_buffer                * sb_free_it;
    sb_add_line_to_stringbuffer   * sb_add_line_to_it;
    sb_linecount_stringbuffer     * sb_linecount_it;
    sb_get_line_from_stringbuffer * sb_get_line_from_it;
};

extern struct sb_type   sb_in_mem;
extern struct sb_type   sb_in_file;


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
