/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.19 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

typedef void cs_init_string P_((struct string *str));
typedef void cs_free_string P_((struct string *str));

typedef int cs_add_streambyte_to_string P_((struct string *str,int ch));

typedef void cs_add_intdata_to_string P_((struct string *str,
					  const struct string *data));
typedef uint16 cs_give_unicode_from_string P_((const struct string *str,
					       int pos, int *found));

typedef void cs_add_unicodedata_to_string P_((struct string *str,
					      int len, const uint16 *data));

typedef int cs_cmp_string P_((struct string *str1,struct string *str2));
				              
typedef unsigned char *cs_stream_from_string P_((const struct string *str, 
						 int printable,
						 screen_info_p terminal,
						 int *reslen));

typedef unsigned char *cs_streamclip_from_string P_((const struct string *str,
						     int *pos, int len,
						     screen_info_p terminal));

typedef int cs_can_ascii_string P_((const struct string *str));

typedef void cs_clip_from_string P_((struct string *ret,
				     const struct string *str,
				     int *pos, int len));

typedef int cs_find_pattern_from_string P_((const struct string *str,
					    const struct string *pattern,
					    int ignore_case));

typedef int cs_add_streambytes_to_string P_((struct string *str, 
					     int count, 
					     const unsigned char *data));

typedef struct  map_info * cs_find_map_type P_((char * map_name));

typedef void cs_remove_control P_((const struct string *str));


typedef void cs_init_state P_((struct charset_state *str));
typedef void cs_free_state P_((struct charset_state *str));
typedef int cs_add_streambyte_to_state P_((struct charset_state *str, int ch));
typedef void cs_soft_reset_state P_((struct charset_state *str));

typedef void cs_add_state_to_string P_((struct string *str, 
					struct charset_state *ch));  
typedef uint16 cs_give_unicode_from_state P_((struct charset_state *st,
					      int *found));
typedef int cs_state_same_char P_((struct charset_state *A,
				   struct charset_state *B,
				   int ignore_case));
typedef int cs_state_printable P_((struct charset_state *st));
typedef int cs_state_is_onebyte P_((struct charset_state *st));


extern struct  charset_type {
    CONST   char                  * type_name;
    cs_init_string                * cs_init_it;
    cs_free_string                * cs_free_it;
    cs_add_streambyte_to_string   * cs_add_streambyte_to_it;
    cs_add_intdata_to_string      * cs_add_intdata_to_it;
    cs_give_unicode_from_string   * cs_give_unicode_from_it;
    cs_add_unicodedata_to_string  * cs_add_unicodedata_to_it;
    cs_cmp_string                 * cs_cmp_it;
    cs_stream_from_string         * cs_stream_from_it;
    cs_can_ascii_string           * cs_can_ascii_it;
    cs_streamclip_from_string     * cs_streamclip_from_it;
    cs_clip_from_string           * cs_clip_from_it;
    cs_find_pattern_from_string   * cs_find_pattern_from_it;
    cs_add_streambytes_to_string  * cs_add_streambytes_to_it;
    cs_find_map_type              * find_map_type;
    cs_remove_control             * cs_remove_control_it;
    cs_add_state_to_string        * cs_add_state_to_it;

    cs_init_state                 * cs_init_s_it;
    cs_free_state                 * cs_free_s_it; 
    cs_add_streambyte_to_state    * cs_add_streambyte_to_s_it;
    cs_soft_reset_state           * cs_soft_reset_s_it;
    cs_give_unicode_from_state    * cs_give_unicode_from_s_it;
    cs_state_same_char            * cs_s_it_same_char;
    cs_state_printable            * cs_s_it_printable;
    cs_state_is_onebyte           * cs_s_it_is_onebyte;

    struct  charset_type    * next_type;
			    
} * cs_first_type;

struct str_private_data {
    int len;
    struct charset_state *state;
    union {
	unsigned char *bytes;
	uint16        *words;
    } a;
};

struct state_utf8 {
    unsigned char  bytes;
    unsigned char  idx;
    long           value;
};

struct state_utf7 {
    unsigned char  encoded;
    unsigned char  bitcount;
    unsigned long  bitval;
    long           value;
};


struct state_private_data {
    unsigned char ready;
    union {
	unsigned char      byte;
	struct state_utf8  utf8;
	struct state_utf7  utf7;
    } a;
};

extern struct charset_type cs_ascii;
extern struct charset_type cs_unknown;
extern struct charset_type cs_onebyte;
extern struct charset_type cs_iso646;
extern struct charset_type cs_utf8;
extern struct charset_type cs_utf7;
extern struct charset_type cs_imap;

typedef void map_init_map P_((struct  map_info *map));

#define MAPPING_NONE         0xFFFF
#define MAP_REV_MAP_DIV      511        /* Large enough? */

struct map_ascii_upper {
    uint16        map_ascii_upper[128];
    unsigned char map_ascii_rev[MAP_REV_MAP_DIV];
};

struct bytemap {
    uint16        map[256];
    unsigned char map_bytemap_rev[MAP_REV_MAP_DIV];
};

struct utfmap {
    int elem_count;
    struct utfelem * elems;  
};

extern struct  map_info {
    struct charset_type *map_type;
    char                *map_name;
    int                 map_initialized;
    map_init_map        *map_init_it;
    union {
	int                    dummy;
	struct map_ascii_upper ascii;	
	struct bytemap         bytemap;
	uint16                 iso646[12];
	struct utfmap          utfmap;
    } b;
} map_ascii, map_latin1, map_koi8r, map_cp1251, map_invariant, map_utf8, 
	map_utf7, map_cp1252, map_koi8u;

extern unsigned char map_fallback_rev P_((unsigned int val, int *found));
extern uint16 map_fallback P_((unsigned int c));
extern int charset_valid_magic P_((charset_t magic));
extern void free_state_internal P_((struct charset_state **state));

enum iso2022_settype { iso2022_other,
		       iso2022_94,
		       iso2022_96,
		       iso2022_94x94,
		       iso2022_96x96      /* Perhaps not exists */
};

enum iso2022_bank { bank_unspecified = -1, 
		    bank_G0 = 0, 
		    bank_G1 = 1, 
		    bank_G2 = 2, 
		    bank_G3 = 3 };

extern struct iso2022_setid { 
    enum iso2022_bank         bank;
    enum iso2022_settype      type;
    unsigned char             bytes[4];
} return_to_iso2022;
	
extern struct setlist {
    struct iso2022_setid * sets[3];
} sets_iso_8859_X[], set_utf8, set_latin8;

extern struct iso2022_setid * CONST ASCII_BANK;

extern char * iso2022_setid_stream P_((const struct iso2022_setid  c));
extern char * lock_shift P_((int r, int bank));

extern int parse_iso2022_specification P_((const char     *param,
					   const char     *value,
					   int            *count,
					   struct setlist *list));
extern struct setlist *loc_setlist P_((const struct setlist l));
extern void print_setlist(FILE *f,struct setlist *l);

extern void dump_map_info P_((FILE *f,struct charcode_info *info));
extern int parse_gen_spec P_((const char *val, 
			      unsigned char *bytes,
			      int size));
extern char * iso2022_codestr P_((unsigned char *bytes, int size));

extern char * terminal_charset_post_init P_((screen_info_p    terminal_info,
					     struct setlist * iso2022_info));

enum unicode_op { UOP_none, UOP_lowercase, UOP_noctrl, 
		  UOP_printable };

/* Returns 0 if char not OK, otherwise char or converted char */
extern uint16 unicode_ch P_((unsigned int ch, enum unicode_op op)); 


extern struct charset_state * new_state_1 P_((charset_t set));
extern FILE * open_mapname P_((const char *name, char **fn));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
