/* eLectrix - a pdf viewer
 * Copyright (C) 2010 Martin Linder <mali2297@users.sf.net>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
#include "e6x-common.h"
#include "e6x-properties-dialog.h"

G_DEFINE_TYPE (E6xPropertiesDialog, e6x_properties_dialog, GTK_TYPE_DIALOG);
static void e6x_properties_dialog_class_init (E6xPropertiesDialogClass *klass);
static void e6x_properties_dialog_init (E6xPropertiesDialog *spinner);
static void e6x_properties_dialog_finalize (GObject *object);
static void e6x_properties_dialog_dispose (GObject *object);

static void
e6x_properties_dialog_class_init (E6xPropertiesDialogClass *klass)
{
  GObjectClass *object_class; 
  
  object_class = G_OBJECT_CLASS (klass);
  object_class->dispose = e6x_properties_dialog_dispose;
  object_class->finalize = e6x_properties_dialog_finalize;
}

static void
e6x_properties_dialog_init (E6xPropertiesDialog *properties)
{
  GtkWidget *c_area = NULL;
  GtkWidget *label = NULL;
  gchar *markup = NULL;
  
  gtk_dialog_add_button (GTK_DIALOG (properties), 
                         GTK_STOCK_CLOSE, 
                         GTK_RESPONSE_CANCEL);
  gtk_dialog_set_default_response (GTK_DIALOG (properties), 
                                   GTK_RESPONSE_CANCEL);
  gtk_window_set_default_size (GTK_WINDOW (properties), 320, 400);
  
  label = gtk_label_new (NULL);
  markup = g_markup_printf_escaped ("<span size=\"large\" weight=\"bold\">%s</span>", 
                                    _("Properties"));
  gtk_label_set_markup (GTK_LABEL (label), markup);
  g_free (markup);
  c_area = gtk_dialog_get_content_area (GTK_DIALOG (properties));
  gtk_box_pack_start (GTK_BOX (c_area), label, FALSE, FALSE, 10);

  g_signal_connect (GTK_WIDGET (properties), "delete-event",
                    G_CALLBACK (gtk_widget_destroy), NULL);
}

static void 
e6x_properties_dialog_finalize (GObject *object)
{
  G_OBJECT_CLASS (e6x_properties_dialog_parent_class)->finalize (object);
}

static void 
e6x_properties_dialog_dispose (GObject *object)
{
  G_OBJECT_CLASS (e6x_properties_dialog_parent_class)->dispose (object);
}

GtkWidget *
e6x_properties_dialog_new (GtkWindow *parent, gchar **entries)
{
  E6xPropertiesDialog *properties = NULL; 
  GtkWidget *table = NULL;
  GtkWidget *label = NULL;
  GtkWidget *c_area = NULL;
  guint len = 0, row = 0;
  gchar **p = NULL, *markup = NULL;
  
  g_return_val_if_fail (entries, NULL);
  
  properties = g_object_new (E6X_TYPE_PROPERTIES_DIALOG, NULL);
  c_area = gtk_dialog_get_content_area (GTK_DIALOG (properties));
  
  if (parent)
  {
    gtk_window_set_transient_for (GTK_WINDOW (properties), parent);
    gtk_window_set_destroy_with_parent (GTK_WINDOW (properties), TRUE);
  }
  
  len = g_strv_length (entries);
  g_assert (len % 3 == 0);
  table = gtk_table_new (len / 3, 2, FALSE);
  gtk_table_set_col_spacings (GTK_TABLE (table), 10);
  gtk_table_set_row_spacings (GTK_TABLE (table), 6);
  gtk_box_pack_start (GTK_BOX (c_area), table, FALSE, FALSE, 0);
  
  for (p = entries; *p; p += 3)
  {
    /* Add name of property */
    label = gtk_label_new (NULL);
    markup = g_markup_printf_escaped ("<span weight=\"bold\">%s:</span>", 
                                      _(*(p + 1)));
    gtk_label_set_markup (GTK_LABEL (label), markup);
    g_free (markup);
    g_object_set (G_OBJECT (label), 
                  "xalign", 1.0, 
                  NULL);
    gtk_table_attach (GTK_TABLE (table), label, 
                      0, 1, row, row + 1, 
                      GTK_FILL, GTK_FILL, 0, 0);
    
    /* Add value of property */
    label = gtk_label_new (*(p + 2));
    g_object_set (G_OBJECT (label), 
                  "xalign", 0.0,
                  "selectable", TRUE,
                  "ellipsize", PANGO_ELLIPSIZE_END,
                  NULL);
    gtk_table_attach (GTK_TABLE (table), label, 
                      1, 2, row, row + 1,
                      GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
    
    row++;
  }
  
  gtk_widget_show_all (c_area);
  
  return GTK_WIDGET (properties);
}

