/* eLectrix - a pdf viewer
 * Copyright (C) 2010, 2011 Martin Linder <mali2297@users.sf.net>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
#pragma once
#ifndef __E6X_PDF_DOCUMENT_H__
#define __E6X_PDF_DOCUMENT_H__

#include "e6x-document.h"

#define E6X_TYPE_PDF_DOCUMENT \
  (e6x_pdf_document_get_type ())
#define E6X_PDF_DOCUMENT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), E6X_TYPE_PDF_DOCUMENT, E6xPdfDocument))
#define E6X_PDF_DOCUMENT_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_CAST ((obj), E6X_TYPE_PDF_DOCUMENT,  E6xPdfDocumentClass))
#define E6X_IS_PDF_DOCUMENT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E6X_TYPE_PDF_DOCUMENT))
#define E6X_IS_PDF_DOCUMENT_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE ((obj), E6X_TYPE_PDF_DOCUMENT))
#define E6X_PDF_DOCUMENT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), E6X_TYPE_PDF_DOCUMENT, E6xPdfDocumentClass))

typedef struct _E6xPdfDocument E6xPdfDocument;
typedef struct _E6xPdfDocumentClass E6xPdfDocumentClass;
typedef struct _E6xPdfDocumentPrivate E6xPdfDocumentPrivate;

struct _E6xPdfDocument
{
  E6xDocument parent;
  E6xPdfDocumentPrivate *priv;
};

struct _E6xPdfDocumentClass
{
  E6xDocumentClass parent_class;
};

GType e6x_pdf_document_get_type ();
GObject *e6x_pdf_document_new (const gchar *filename,
                               const gchar *passwd,
                               GError **error);

#endif /* __E6X_PDF_DOCUMENT_H__ */
