/* Copyright (C) 2010, 2011 Martin Linder <mali2297@users.sf.net>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
#pragma once
#ifndef __E6X_DIALOGS_H__
#define __E6X_DIALOGS_H__

#include <gtk/gtk.h>
#include "e6x-document.h"

E6xDocument *e6x_dialogs_open_file (GtkWindow *win);
E6xDocument *e6x_dialogs_decrypt (E6xDocument *doc,
                                  GtkWindow *win);
void e6x_dialogs_save_copy (E6xDocument *doc,
                            GtkWindow *win);
gchar *e6x_dialogs_get_copyname (const gchar *filename,
                                 const gchar *dialogtitle,
                                 GtkWindow *win);
void e6x_dialogs_print (E6xDocument *doc, 
                        GtkWindow *win);
void e6x_dialogs_properties (E6xDocument *doc,
                             GtkWindow *win);
void e6x_dialogs_about (GtkWindow *win);
void e6x_dialogs_show_error_message (GtkWindow *win,
                                     const gchar *message);
gchar *e6x_dialogs_get_password (GtkWindow *win);
void e6x_dialogs_open_with (const gchar *path, 
                            GtkWindow *win);

#endif /* __E6X_DIALOGS_H__ */
