// generated by Fast Light User Interface Designer (fluid) version 2,0003

#include "preferences.h"
#include <stdlib.h>
#include <efltk/filename.h>
void readPrefs();
void writePrefs();

static void closeWindowCB( Fl_Widget*, void* ) {
  delete myWindow;
}

static void saveAndCloseWindowCB( Fl_Widget*, void* ) {
  writePrefs();
    delete myWindow;
}

Fl_Window* myWindow;

Fl_Input* wAlarm;

Fl_Choice* wAmPm;

Fl_Choice* wWear;

Fl_Check_Button* wShower;

Fl_Check_Button* wShave;

Fl_Check_Button* wBrush;

Fl_Round_Button* wLeft;

Fl_Round_Button* wRight;

Fl_Choice* wDrink;

Fl_Check_Button* wMilk;

Fl_Choice* wBread;

Fl_Check_Button* wButter;

Fl_Int_Input* wEggs;

Fl_Value_Slider* wMinutes;

Fl_Input* wPaper;
int main (int argc, char **argv) 
{
  Fl_Window* w;
  Fl::args(argc, argv);
   {Fl_Window* o = myWindow = new Fl_Window(298, 311, "My Preferences");
    w = o;
    o->callback((Fl_Callback*)closeWindowCB);
     {Fl_Button* o = new Fl_Button(210, 275, 75, 25, "Cancel");
      o->callback((Fl_Callback*)closeWindowCB);
    }
     {Fl_Button* o = new Fl_Button(125, 275, 75, 25, "OK");
      o->callback((Fl_Callback*)saveAndCloseWindowCB);
    }
     {Fl_Group* o = new Fl_Group(20, 30, 115, 225, "Get Up:");
      o->box(FL_BORDER_FRAME);
      o->color((Fl_Color)37);
      o->align(FL_ALIGN_TOP | FL_ALIGN_LEFT);
       {Fl_Input* o = wAlarm = new Fl_Input(5, 25, 45, 20, "Alarm at:");
        o->align(FL_ALIGN_TOP | FL_ALIGN_LEFT);
      }
       {Fl_Choice* o = wAmPm = new Fl_Choice(55, 25, 55, 20); o->begin();
        new Fl_Item("a.m.");
        new Fl_Item("p.m.");
        o->end();
      }
       {Fl_Choice* o = wWear = new Fl_Choice(5, 70, 105, 20, "Wear:"); o->begin();
        o->align(FL_ALIGN_TOP | FL_ALIGN_LEFT);
        new Fl_Item("shoes");
        new Fl_Item("sandals");
        new Fl_Item("flip flops");
        new Fl_Item("bare foot");
        o->end();
      }
      wShower = new Fl_Check_Button(5, 155, 105, 20, "shower");
      wShave = new Fl_Check_Button(5, 175, 105, 20, "shave");
      wBrush = new Fl_Check_Button(5, 195, 105, 20, "brush teeth");
       {Fl_Group* o = new Fl_Group(5, 95, 105, 60);
         {Fl_Round_Button* o = wLeft = new Fl_Round_Button(0, 0, 105, 20, "left side");
          o->type(Fl_Round_Button::RADIO);
        }
         {Fl_Round_Button* o = wRight = new Fl_Round_Button(0, 20, 105, 20, "right side");
          o->type(Fl_Round_Button::RADIO);
        }
         {Fl_Box* o = new Fl_Box(20, 40, 80, 15, "of the bed");
          o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
        }
        o->end();
      }
      o->end();
    }
     {Fl_Group* o = new Fl_Group(160, 30, 115, 225, "Breakfast::");
      o->box(FL_BORDER_FRAME);
      o->color((Fl_Color)37);
      o->align(FL_ALIGN_TOP | FL_ALIGN_LEFT);
       {Fl_Choice* o = wDrink = new Fl_Choice(5, 20, 105, 20, "Drink:"); o->begin();
        o->align(FL_ALIGN_TOP | FL_ALIGN_LEFT);
        new Fl_Item("coffee");
        new Fl_Item("tea");
        new Fl_Item("juice");
        o->end();
      }
      wMilk = new Fl_Check_Button(10, 40, 100, 25, "with milk");
       {Fl_Choice* o = wBread = new Fl_Choice(5, 80, 105, 20, "Bread:"); o->begin();
        o->align(FL_ALIGN_TOP | FL_ALIGN_LEFT);
        new Fl_Item("wheat");
        new Fl_Item("white");
        new Fl_Item("rye");
        new Fl_Item("sour doh");
        o->end();
      }
      wButter = new Fl_Check_Button(10, 100, 100, 25, "with butter");
       {Fl_Int_Input* o = wEggs = new Fl_Int_Input(5, 133, 30, 20, "eggs");
        o->type(2);
        o->align(FL_ALIGN_RIGHT);
      }
       {Fl_Value_Slider* o = wMinutes = new Fl_Value_Slider(5, 155, 80, 20, "min.");
        o->type(Fl_Value_Slider::HORIZONTAL);
        o->maximum(2);
        o->value(1);
        o->align(FL_ALIGN_RIGHT);
      }
       {Fl_Input* o = wPaper = new Fl_Input(5, 195, 105, 20, "Newspaper:");
        o->align(FL_ALIGN_TOP | FL_ALIGN_LEFT);
      }
      o->end();
    }
    o->end();
  }
  readPrefs();
  w->show(argc, argv);
  return  Fl::run();
}

void readPrefs() {
  int boolValue;
  int intValue;
  char buffer[80];
  double doubleValue;
  
  Fl_Config app( "efltk", "pref_test", Fl_Config::USER );
  
      app.set_section( "Bed" );
      app.read("alarm", buffer, "8:00", sizeof(buffer) );
      wAlarm->value( buffer );
  
      app.read("ampm", intValue, 0 );
      wAmPm->value( intValue );
  
      app.read( "wear", intValue, 1 );
      wWear->value( intValue );
  
      int side;
      app.read( "side", side, 2 );
      if ( side == 1 ) wLeft->value( 1 );
      if ( side == 2 ) wRight->value( 1 );
  
      int tasks;
      app.read( "taskFlags", tasks, 0x05 );
      if ( tasks & 0x01 ) wShower->value( 1 );
      if ( tasks & 0x02 ) wShave->value( 1 );
      if ( tasks & 0x04 ) wBrush->value( 1 );
  
    app.set_section( "Breakfast" );
  
      app.read( "drink", intValue,1 );
      wDrink->value( intValue );
  
      app.read( "wMilk", boolValue, 0 );
      wMilk->value( boolValue );
  
      app.read( "bread", intValue, 0 );
      wBread->value( intValue );
  
      app.read( "wButter", boolValue,1 );
      wButter->value( boolValue );
  
      app.read( "nEggs", intValue, 2 );
      char tmp[16]; sprintf( tmp, "%d", intValue );
      wEggs->value( tmp );
  
      app.read( "minutes", doubleValue, 3.2 );
      wMinutes->value( doubleValue );
  
      char *flexBuffer=0;
      app.read( "newspaper", flexBuffer, "NY Tymes" );
      wPaper->value( flexBuffer );
      if ( !flexBuffer && !app.error() ) delete []flexBuffer;
}

void writePrefs() {
  Fl_Config app("efltk", "pref_test", Fl_Config::USER);
  
      app.set_section("Bed");
      app.write( "alarm", wAlarm->value() );
      app.write( "ampm", wAmPm->value() );
      app.write( "wear", wWear->value() );
  
      int side = 0;
      if ( wLeft->value() ) side = 1;
      if ( wRight->value() ) side = 2;
      app.write( "side", side );
  
      int tasks = 0;
      if ( wShower->value() ) tasks |= 0x01;
      if ( wShave->value() ) tasks |= 0x02;
      if ( wBrush->value() ) tasks |= 0x04;
      app.write( "taskFlags", tasks );
  
      app.set_section("Breakfast");
      app.write( "drink", wDrink->value() );
      app.write( "wMilk", wMilk->value() );
      app.write( "bread", wBread->value() );
      app.write( "wButter", wButter->value() );
  
      app.write( "nEggs", wEggs->value() );
      app.write( "minutes", (double)wMinutes->value() );
  
      app.write( "newspaper", wPaper->value() );
}
