# Contributing to `echomap`

Thanks for your interest in contributing! We follow the ["fork and pull"](https://docs.github.com/en/free-pro-team@latest/github/collaborating-with-issues-and-pull-requests/about-collaborative-development-models) model where contributors create personal forks of this repository, commit changes on a new branch, and then open pull requests for their updates to be reviewed and merged.

To get started, you can look for [issues labeled "help wanted"](https://github.com/pjsier/echomap/issues?q=is%3Aopen+is%3Aissue+label%3A%22help+wanted%22) and post a comment that you're interested as well as any questions you have about the issue. If the issue is available you'll be assigned, and from there you can create a pull request with your updates.

All contributors are expected to follow our [code of conduct](./CODE_OF_CONDUCT.md).

## Pull Requests

GitHub has [documentation on creating pull requests](https://docs.github.com/en/free-pro-team@latest/github/collaborating-with-issues-and-pull-requests/about-pull-requests) that explains the overall workflow. By default, new pull requests should be opened against the `main` branch of this repo.

## Bug Reports

Find something that isn't working the way it should? First, take a look through our [existing issues](https://github.com/pjsier/echomap/issues) to see if someone has already reported it, and if not feel free to create a new issue. If you're not sure if your issue has already been raised, go ahead and make a new one, we'd rather get a duplicate than miss a bug.

## Feature Requests

Have an idea for a useful feature that isn't currently supported? Review our [open issues](https://github.com/pjsier/echomap/issues) to see if it's already been mentioned, and if not you can create a new issue to discuss it.
