// SPDX-FileCopyrightText: 2019-2022 Connor McLaughlin <stenzek@gmail.com>
// SPDX-License-Identifier: (GPL-3.0 OR CC-BY-NC-ND-4.0)

#pragma once
#include "common/string.h"
#include "common/types.h"
#include <array>
#include <cstring>
#include <linux/input-event-codes.h>
#include <map>
#include <optional>
#include <string_view>

namespace VTYKeyNames {

static const std::map<int, const char*> s_evdev_key_names = {{KEY_ESC, "Escape"},
                                                             {KEY_1, "1"},
                                                             {KEY_2, "2"},
                                                             {KEY_3, "3"},
                                                             {KEY_4, "4"},
                                                             {KEY_5, "5"},
                                                             {KEY_6, "6"},
                                                             {KEY_7, "7"},
                                                             {KEY_8, "8"},
                                                             {KEY_9, "9"},
                                                             {KEY_0, "0"},
                                                             {KEY_MINUS, "Minus"},
                                                             {KEY_EQUAL, "Equal"},
                                                             {KEY_BACKSPACE, "Backspace"},
                                                             {KEY_TAB, "Tab"},
                                                             {KEY_Q, "Q"},
                                                             {KEY_W, "W"},
                                                             {KEY_E, "E"},
                                                             {KEY_R, "R"},
                                                             {KEY_T, "T"},
                                                             {KEY_Y, "Y"},
                                                             {KEY_U, "U"},
                                                             {KEY_I, "I"},
                                                             {KEY_O, "O"},
                                                             {KEY_P, "P"},
                                                             {KEY_LEFTBRACE, "Leftbrace"},
                                                             {KEY_RIGHTBRACE, "Rightbrace"},
                                                             {KEY_ENTER, "Return"},
                                                             {KEY_LEFTCTRL, "Leftctrl"},
                                                             {KEY_A, "A"},
                                                             {KEY_S, "S"},
                                                             {KEY_D, "D"},
                                                             {KEY_F, "F"},
                                                             {KEY_G, "G"},
                                                             {KEY_H, "H"},
                                                             {KEY_J, "J"},
                                                             {KEY_K, "K"},
                                                             {KEY_L, "L"},
                                                             {KEY_SEMICOLON, "Semicolon"},
                                                             {KEY_APOSTROPHE, "Apostrophe"},
                                                             {KEY_GRAVE, "Grave"},
                                                             {KEY_LEFTSHIFT, "Leftshift"},
                                                             {KEY_BACKSLASH, "Backslash"},
                                                             {KEY_Z, "Z"},
                                                             {KEY_X, "X"},
                                                             {KEY_C, "C"},
                                                             {KEY_V, "V"},
                                                             {KEY_B, "B"},
                                                             {KEY_N, "N"},
                                                             {KEY_M, "M"},
                                                             {KEY_COMMA, "Comma"},
                                                             {KEY_DOT, "Dot"},
                                                             {KEY_SLASH, "Slash"},
                                                             {KEY_RIGHTSHIFT, "Rightshift"},
                                                             {KEY_KPASTERISK, "Kpasterisk"},
                                                             {KEY_LEFTALT, "Leftalt"},
                                                             {KEY_SPACE, "Space"},
                                                             {KEY_CAPSLOCK, "Capslock"},
                                                             {KEY_F1, "F1"},
                                                             {KEY_F2, "F2"},
                                                             {KEY_F3, "F3"},
                                                             {KEY_F4, "F4"},
                                                             {KEY_F5, "F5"},
                                                             {KEY_F6, "F6"},
                                                             {KEY_F7, "F7"},
                                                             {KEY_F8, "F8"},
                                                             {KEY_F9, "F9"},
                                                             {KEY_F10, "F10"},
                                                             {KEY_NUMLOCK, "Numlock"},
                                                             {KEY_SCROLLLOCK, "Scrolllock"},
                                                             {KEY_KP7, "Kp7"},
                                                             {KEY_KP8, "Kp8"},
                                                             {KEY_KP9, "Kp9"},
                                                             {KEY_KPMINUS, "Kpminus"},
                                                             {KEY_KP4, "Kp4"},
                                                             {KEY_KP5, "Kp5"},
                                                             {KEY_KP6, "Kp6"},
                                                             {KEY_KPPLUS, "Kpplus"},
                                                             {KEY_KP1, "Kp1"},
                                                             {KEY_KP2, "Kp2"},
                                                             {KEY_KP3, "Kp3"},
                                                             {KEY_KP0, "Kp0"},
                                                             {KEY_KPDOT, "Kpdot"},
                                                             {KEY_ZENKAKUHANKAKU, "Zenkakuhankaku"},
                                                             {KEY_102ND, "102nd"},
                                                             {KEY_F11, "F11"},
                                                             {KEY_F12, "F12"},
                                                             {KEY_RO, "Ro"},
                                                             {KEY_KATAKANA, "Katakana"},
                                                             {KEY_HIRAGANA, "Hiragana"},
                                                             {KEY_HENKAN, "Henkan"},
                                                             {KEY_KATAKANAHIRAGANA, "Katakanahiragana"},
                                                             {KEY_MUHENKAN, "Muhenkan"},
                                                             {KEY_KPJPCOMMA, "Kpjpcomma"},
                                                             {KEY_KPENTER, "Kpenter"},
                                                             {KEY_RIGHTCTRL, "Rightctrl"},
                                                             {KEY_KPSLASH, "Kpslash"},
                                                             {KEY_SYSRQ, "Sysrq"},
                                                             {KEY_RIGHTALT, "RightAlt"},
                                                             {KEY_LINEFEED, "Linefeed"},
                                                             {KEY_HOME, "Home"},
                                                             {KEY_UP, "Up"},
                                                             {KEY_PAGEUP, "PageUp"},
                                                             {KEY_LEFT, "Left"},
                                                             {KEY_RIGHT, "Right"},
                                                             {KEY_END, "End"},
                                                             {KEY_DOWN, "Down"},
                                                             {KEY_PAGEDOWN, "PageDown"},
                                                             {KEY_INSERT, "Insert"},
                                                             {KEY_DELETE, "Delete"},
                                                             {KEY_MACRO, "Macro"},
                                                             {KEY_MUTE, "Mute"},
                                                             {KEY_VOLUMEDOWN, "VolumeDown"},
                                                             {KEY_VOLUMEUP, "VolumeUp"},
                                                             {KEY_POWER, "Power"},
                                                             {KEY_KPEQUAL, "Kpequal"},
                                                             {KEY_KPPLUSMINUS, "Kpplusminus"},
                                                             {KEY_PAUSE, "Pause"},
                                                             {KEY_SCALE, "Scale"},
                                                             {KEY_KPCOMMA, "Kpcomma"},
                                                             {KEY_HANGEUL, "Hangeul"},
                                                             {KEY_HANGUEL, "Hanguel"},
                                                             {KEY_HANJA, "Hanja"},
                                                             {KEY_YEN, "Yen"},
                                                             {KEY_LEFTMETA, "Leftmeta"},
                                                             {KEY_RIGHTMETA, "Rightmeta"},
                                                             {KEY_COMPOSE, "Compose"},
                                                             {KEY_STOP, "Stop"},
                                                             {KEY_AGAIN, "Again"},
                                                             {KEY_PROPS, "Props"},
                                                             {KEY_UNDO, "Undo"},
                                                             {KEY_FRONT, "Front"},
                                                             {KEY_COPY, "Copy"},
                                                             {KEY_OPEN, "Open"},
                                                             {KEY_PASTE, "Paste"},
                                                             {KEY_FIND, "Find"},
                                                             {KEY_CUT, "Cut"},
                                                             {KEY_HELP, "Help"},
                                                             {KEY_MENU, "Menu"},
                                                             {KEY_CALC, "Calc"},
                                                             {KEY_SETUP, "Setup"},
                                                             {KEY_SLEEP, "Sleep"},
                                                             {KEY_WAKEUP, "Wakeup"},
                                                             {KEY_FILE, "File"},
                                                             {KEY_SENDFILE, "Sendfile"},
                                                             {KEY_DELETEFILE, "Deletefile"},
                                                             {KEY_XFER, "Xfer"},
                                                             {KEY_PROG1, "Prog1"},
                                                             {KEY_PROG2, "Prog2"},
                                                             {KEY_WWW, "Www"},
                                                             {KEY_MSDOS, "Msdos"},
                                                             {KEY_COFFEE, "Coffee"},
                                                             {KEY_SCREENLOCK, "Screenlock"},
                                                             {KEY_ROTATE_DISPLAY, "Rotate_display"},
                                                             {KEY_DIRECTION, "Direction"},
                                                             {KEY_CYCLEWINDOWS, "Cyclewindows"},
                                                             {KEY_MAIL, "Mail"},
                                                             {KEY_BOOKMARKS, "Bookmarks"},
                                                             {KEY_COMPUTER, "Computer"},
                                                             {KEY_BACK, "Back"},
                                                             {KEY_FORWARD, "Forward"},
                                                             {KEY_CLOSECD, "Closecd"},
                                                             {KEY_EJECTCD, "Ejectcd"},
                                                             {KEY_EJECTCLOSECD, "Ejectclosecd"},
                                                             {KEY_NEXTSONG, "Nextsong"},
                                                             {KEY_PLAYPAUSE, "Playpause"},
                                                             {KEY_PREVIOUSSONG, "Previoussong"},
                                                             {KEY_STOPCD, "Stopcd"},
                                                             {KEY_RECORD, "Record"},
                                                             {KEY_REWIND, "Rewind"},
                                                             {KEY_PHONE, "Phone"},
                                                             {KEY_ISO, "Iso"},
                                                             {KEY_CONFIG, "Config"},
                                                             {KEY_HOMEPAGE, "Homepage"},
                                                             {KEY_REFRESH, "Refresh"},
                                                             {KEY_EXIT, "Exit"},
                                                             {KEY_MOVE, "Move"},
                                                             {KEY_EDIT, "Edit"},
                                                             {KEY_SCROLLUP, "Scrollup"},
                                                             {KEY_SCROLLDOWN, "Scrolldown"},
                                                             {KEY_KPLEFTPAREN, "Kpleftparen"},
                                                             {KEY_KPRIGHTPAREN, "Kprightparen"},
                                                             {KEY_NEW, "New"},
                                                             {KEY_REDO, "Redo"},
                                                             {KEY_F13, "F13"},
                                                             {KEY_F14, "F14"},
                                                             {KEY_F15, "F15"},
                                                             {KEY_F16, "F16"},
                                                             {KEY_F17, "F17"},
                                                             {KEY_F18, "F18"},
                                                             {KEY_F19, "F19"},
                                                             {KEY_F20, "F20"},
                                                             {KEY_F21, "F21"},
                                                             {KEY_F22, "F22"},
                                                             {KEY_F23, "F23"},
                                                             {KEY_F24, "F24"},
                                                             {KEY_PLAYCD, "Playcd"},
                                                             {KEY_PAUSECD, "Pausecd"},
                                                             {KEY_PROG3, "Prog3"},
                                                             {KEY_PROG4, "Prog4"},
                                                             {KEY_DASHBOARD, "Dashboard"},
                                                             {KEY_SUSPEND, "Suspend"},
                                                             {KEY_CLOSE, "Close"},
                                                             {KEY_PLAY, "Play"},
                                                             {KEY_FASTFORWARD, "Fastforward"},
                                                             {KEY_BASSBOOST, "Bassboost"},
                                                             {KEY_PRINT, "Print"},
                                                             {KEY_HP, "Hp"},
                                                             {KEY_CAMERA, "Camera"},
                                                             {KEY_SOUND, "Sound"},
                                                             {KEY_QUESTION, "Question"},
                                                             {KEY_EMAIL, "Email"},
                                                             {KEY_CHAT, "Chat"},
                                                             {KEY_SEARCH, "Search"},
                                                             {KEY_CONNECT, "Connect"},
                                                             {KEY_FINANCE, "Finance"},
                                                             {KEY_SPORT, "Sport"},
                                                             {KEY_SHOP, "Shop"},
                                                             {KEY_ALTERASE, "Alterase"},
                                                             {KEY_CANCEL, "Cancel"},
                                                             {KEY_BRIGHTNESSDOWN, "Brightnessdown"},
                                                             {KEY_BRIGHTNESSUP, "Brightnessup"},
                                                             {KEY_MEDIA, "Media"},
                                                             {KEY_SWITCHVIDEOMODE, "Switchvideomode"},
                                                             {KEY_KBDILLUMTOGGLE, "Kbdillumtoggle"},
                                                             {KEY_KBDILLUMDOWN, "Kbdillumdown"},
                                                             {KEY_KBDILLUMUP, "Kbdillumup"},
                                                             {KEY_SEND, "Send"},
                                                             {KEY_REPLY, "Reply"},
                                                             {KEY_FORWARDMAIL, "Forwardmail"},
                                                             {KEY_SAVE, "Save"},
                                                             {KEY_DOCUMENTS, "Documents"},
                                                             {KEY_BATTERY, "Battery"},
                                                             {KEY_BLUETOOTH, "Bluetooth"},
                                                             {KEY_WLAN, "Wlan"},
                                                             {KEY_UWB, "Uwb"},
                                                             {KEY_UNKNOWN, "Unknown"},
                                                             {KEY_VIDEO_NEXT, "Video_next"},
                                                             {KEY_VIDEO_PREV, "Video_prev"},
                                                             {KEY_BRIGHTNESS_CYCLE, "Brightness_cycle"},
                                                             {KEY_BRIGHTNESS_AUTO, "Brightness_auto"},
                                                             {KEY_BRIGHTNESS_ZERO, "Brightness_zero"},
                                                             {KEY_DISPLAY_OFF, "Display_off"},
                                                             {KEY_WWAN, "Wwan"},
                                                             {KEY_WIMAX, "Wimax"},
                                                             {KEY_RFKILL, "Rfkill"},
                                                             {KEY_MICMUTE, "Micmute"}};

static inline const char* GetKeyName(int key)
{
  const auto it = s_evdev_key_names.find(key);
  return it == s_evdev_key_names.end() ? nullptr : it->second;
}

static inline std::optional<int> GetKeyCodeForName(const std::string_view key_name)
{
  for (const auto& it : s_evdev_key_names)
  {
    if (key_name == it.second)
      return it.first;
  }

  return std::nullopt;
}

} // namespace VTYKeyNames
