/*
 * API functions for libdoom-umapinfo
 *
 * Copyright (c) 2022-2023 by the developers. See the LICENSE file for details.
 */

#include "doomdef.h"
#ifdef ENABLE_UMAPINFO

#include "doom_umi_internal.h"
  // DOOM_UMI1_I_KEYWORDS
  // NUM_UMI_THINGS

// Keywords and names recognized by UMAPINFO.

/*
 * An index to this table is used for values
 *
 * Ensure that DOOM_UMI1_I_KEYWORDS is defined to the number of entries.
 * Ensure that DOOM_UMI1_KEY elements are defined to the indices of this array.
 *
 * Attention: Do not change the order and append new keywords to the end!
 * Otherwise the ABI is broken and this requires a new major version.
 */

// These are keywords that can have values assigned to them by umapinfo.
// Keyword matching is done using lowercase.
// indexed by  umi_keyword_e
const char * const umi_keyword_name[ NUM_UMI_KEYWORDS ] =
{
    "author",
    "label",
    "levelname",
    "levelpic",
    "next",
    "nextsecret",
    "skytexture",
    "music",
    "exitpic",
    "enterpic", 
    "partime",
    "endgame",
    "endpic",
    "endbunny",
    "endcast",
    "nointermission",
    "intertext",
    "intertextsecret",
    "interbackdrop",
    "intermusic",
    "episode",
    "bossaction"
};


/* An index to this table is used for values
 *
 * Ensure that NUM_UMI_THINGS is defined to the number of entries!
 */
// Indexed by thingid
const char * const umi_thing_name[ NUM_UMI_THINGS ] =
{
    "DoomPlayer",
    "ZombieMan",
    "ShotgunGuy",
    "Archvile",
    "ArchvileFire",
    "Revenant",
    "RevenantTracer",
    "RevenantTracerSmoke",
    "Fatso", "FatShot",
    "ChaingunGuy",
    "DoomImp",
    "Demon",
    "Spectre",
    "Cacodemon",
    "BaronOfHell",
    "BaronBall",
    "HellKnight",
    "LostSoul",
    "SpiderMastermind",
    "Arachnotron",
    "Cyberdemon",
    "PainElemental",
    "WolfensteinSS",
    "CommanderKeen",
    "BossBrain",
    "BossEye",
    "BossTarget",
    "SpawnShot",
    "SpawnFire",
    "ExplosiveBarrel",
    "DoomImpBall",
    "CacodemonBall",
    "Rocket",
    "PlasmaBall",
    "BFGBall",
    "ArachnotronPlasma",
    "BulletPuff",
    "Blood",
    "TeleportFog",
    "ItemFog",
    "TeleportDest",
    "BFGExtra",
    "GreenArmor",
    "BlueArmor",
    "HealthBonus",
    "ArmorBonus",
    "BlueCard",
    "RedCard",
    "YellowCard",
    "YellowSkull",
    "RedSkull",
    "BlueSkull",
    "Stimpack", 
    "Medikit",
    "Soulsphere",
    "InvulnerabilitySphere",
    "Berserk",
    "BlurSphere",
    "RadSuit",
    "Allmap",
    "Infrared",
    "Megasphere",
    "Clip",
    "ClipBox",
    "RocketAmmo",
    "RocketBox",
    "Cell",
    "CellPack",
    "Shell",
    "ShellBox",
    "Backpack",
    "BFG9000",
    "Chaingun",
    "Chainsaw",
    "RocketLauncher",
    "PlasmaRifle",
    "Shotgun",
    "SuperShotgun",
    "TechLamp",
    "TechLamp2",
    "Column",
    "TallGreenColumn",
    "ShortGreenColumn",
    "TallRedColumn",
    "ShortRedColumn",
    "SkullColumn",
    "HeartColumn",
    "EvilEye",
    "FloatingSkull",
    "TorchTree",
    "BlueTorch",
    "GreenTorch",
    "RedTorch",
    "ShortBlueTorch",
    "ShortGreenTorch",
    "ShortRedTorch",
    "Stalagtite",
    "TechPillar",
    "CandleStick",
    "Candelabra",
    "BloodyTwitch",
    "Meat2",
    "Meat3",
    "Meat4",
    "Meat5",
    "NonsolidMeat2",
    "NonsolidMeat4",
    "NonsolidMeat3",
    "NonsolidMeat5",
    "NonsolidTwitch",
    "DeadCacodemon",
    "DeadMarine",
    "DeadZombieMan",
    "DeadDemon",
    "DeadLostSoul",
    "DeadDoomImp",
    "DeadShotgunGuy",
    "GibbedMarine",
    "GibbedMarineExtra",
    "HeadsOnAStick",
    "Gibs",
    "HeadOnAStick",
    "HeadCandles",
    "DeadStick",
    "LiveStick",
    "BigTree",
    "BurningBarrel",
    "HangNoGuts",
    "HangBNoBrain",
    "HangTLookingDown",
    "HangTSkull",
    "HangTLookingUp",
    "HangTNoBrain",
    "ColonGibs",
    "SmallBloodPool",
    "BrainStem",
    /* Boom/MBF */
    "PointPusher",
    "PointPuller",
    "MBFHelperDog",
    "PlasmaBall1",
    "PlasmaBall2",
    "EvilSceptre",
    "UnholyBible",
    "MusicChanger",

    /* ==================================================================== */
    /* Available since UMAPINFO Rev 1.5 */

    "Deh_Actor_145",
    "Deh_Actor_146",
    "Deh_Actor_147",
    "Deh_Actor_148",
    "Deh_Actor_149",
    /* DHEXTRA */
    "Deh_Actor_150",
    "Deh_Actor_151",
    "Deh_Actor_152",
    "Deh_Actor_153",
    "Deh_Actor_154",
    "Deh_Actor_155",
    "Deh_Actor_156",
    "Deh_Actor_157",
    "Deh_Actor_158",
    "Deh_Actor_159",
    "Deh_Actor_160",
    "Deh_Actor_161",
    "Deh_Actor_162",
    "Deh_Actor_163",
    "Deh_Actor_164",
    "Deh_Actor_165",
    "Deh_Actor_166",
    "Deh_Actor_167",
    "Deh_Actor_168",
    "Deh_Actor_169",
    "Deh_Actor_170",
    "Deh_Actor_171",
    "Deh_Actor_172",
    "Deh_Actor_173",
    "Deh_Actor_174",
    "Deh_Actor_175",
    "Deh_Actor_176",
    "Deh_Actor_167",
    "Deh_Actor_178",
    "Deh_Actor_179",
    "Deh_Actor_180",
    "Deh_Actor_181",
    "Deh_Actor_182",
    "Deh_Actor_183",
    "Deh_Actor_184",
    "Deh_Actor_185",
    "Deh_Actor_186",
    "Deh_Actor_187",
    "Deh_Actor_188",
    "Deh_Actor_189",
    "Deh_Actor_190",
    "Deh_Actor_191",
    "Deh_Actor_192",
    "Deh_Actor_193",
    "Deh_Actor_194",
    "Deh_Actor_195",
    "Deh_Actor_196",
    "Deh_Actor_197",
    "Deh_Actor_198",
    "Deh_Actor_199",
    "Deh_Actor_200", 
    "Deh_Actor_201",
    "Deh_Actor_202",
    "Deh_Actor_203",
    "Deh_Actor_204",
    "Deh_Actor_205",
    "Deh_Actor_206",
    "Deh_Actor_207",
    "Deh_Actor_208",
    "Deh_Actor_209",
    "Deh_Actor_210",
    "Deh_Actor_211",
    "Deh_Actor_212",
    "Deh_Actor_213",
    "Deh_Actor_214",
    "Deh_Actor_215",
    "Deh_Actor_216",
    "Deh_Actor_217",
    "Deh_Actor_218",
    "Deh_Actor_219",
    "Deh_Actor_220",
    "Deh_Actor_221",
    "Deh_Actor_222",
    "Deh_Actor_223",
    "Deh_Actor_224",
    "Deh_Actor_225",
    "Deh_Actor_226",
    "Deh_Actor_227",
    "Deh_Actor_228",
    "Deh_Actor_229",
    "Deh_Actor_230",
    "Deh_Actor_231",
    "Deh_Actor_232",
    "Deh_Actor_233",
    "Deh_Actor_234",
    "Deh_Actor_235",
    "Deh_Actor_236",
    "Deh_Actor_237",
    "Deh_Actor_238",
    "Deh_Actor_238",
    "Deh_Actor_240",
    "Deh_Actor_241",
    "Deh_Actor_242",
    "Deh_Actor_243",
    "Deh_Actor_244",
    "Deh_Actor_245",
    "Deh_Actor_246",
    "Deh_Actor_247",
    "Deh_Actor_248",
    "Deh_Actor_249"
};

// UMAPINFO end
#endif
/* EOF */
