// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id: p_pspr.h 1714 2025-01-25 05:45:33Z wesleyjohnson $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Portions Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: p_pspr.h,v $
// Revision 1.3  2001/01/25 22:15:43  bpereira
// added heretic support
//
// Revision 1.2  2000/02/27 00:42:10  hurdler
// Revision 1.1.1.1  2000/02/22 20:32:32  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//  Sprite animation.
//
//-----------------------------------------------------------------------------

#ifndef P_PSPR_H
#define P_PSPR_H

// Basic data types.
// Needs fixed point, and BAM angles.
#include "m_fixed.h"
#include "tables.h"


//
// Needs to include the precompiled
//  sprite animation tables.
// Header generated by multigen utility.
// This includes all the data for thing animation,
// i.e. the Thing Atrributes table
// and the Frame Sequence table.
#include "info.h"
 // state_t

#ifdef __GNUG__
#pragma interface
#endif


// faB:
//  MF_SHADOW is no more used to activate translucency (or the old fuzzy)
//  The frame field allows to set translucency per frame, instead of per sprite.
//  Now, (frame & FF_TRANSMASK) is the translucency table number, if 0
//  it is not translucent.

// Note:
//  MF_SHADOW still affects the targeting for monsters (they miss more)

// translucent effect
#define FF_TRANSMASK   0x70000  // 0 = no trans(opaque), 1-7 = transl. table
#define FF_TRANSSHIFT       16

// faB: new 'alpha' shade effect, for smoke..

#define FF_SMOKESHADE  0x80000  // sprite is an alpha channel

#define FF_TRANSLU_TABLE_INDEX( fr )   (((fr)&FF_TRANSMASK) - 0x10000)


//
// Overlay psprites are scaled shapes
// drawn directly on the view screen,
// coordinates are given for a 320*200 view screen.
//
typedef enum
{
    PS_weapon,
    PS_flash,
    NUMPSPRITES

} psprnum_t;

typedef struct
{
    state_t*    state;  // a NULL state means not active
    int         tics;
    fixed_t     sx;
    fixed_t     sy;

} pspdef_t;

void P_OpenWeapons(void);
void P_CloseWeapons(void);

#endif
