/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.editor;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.diylc.common.PropertyWrapper;
import org.diylc.utils.Constants;

public class StringEditor
extends JTextField {
    private static final long serialVersionUID = 1L;
    private Color oldBg = this.getBackground();
    private final PropertyWrapper property;

    public StringEditor(PropertyWrapper propertyWrapper) {
        super(propertyWrapper.getValue() == null ? "" : (String)propertyWrapper.getValue());
        this.property = propertyWrapper;
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                StringEditor.this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                StringEditor.this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                StringEditor.this.textChanged();
            }
        });
        if (!propertyWrapper.isUnique()) {
            this.setBackground(Constants.MULTI_VALUE_COLOR);
        }
    }

    private void textChanged() {
        this.property.setChanged(true);
        this.setBackground(this.oldBg);
        this.property.setValue(this.getText());
    }
}

