require 'div/div'
require 'div/tofusession'
require 'drb/drb'
require 'tofu/proxy'

# RWiki Div Interface

class BaseDiv < Div::Div
  set_erb('base.erb')

  def initialize(session)
    super(session)
    @css = nil
    @theme = ThemeDiv.new(session, self)
    @rwiki = RWikiDiv.new(session)
    @todo = RWikiToDoDiv.new(session)
  end
  attr_accessor :css
end

class YourTofuSession < Div::TofuSession
  def initialize(bartender, hint=nil)
    super(bartender, hint)
    @base = BaseDiv.new(self)
  end

  def do_GET(context)
    update_div(context)
    context.res_header('content-type', 'text/html; charset=euc-jp')
    context.res_body(@base.to_html(context))
  end
end

if __FILE__ == $0
  require 'drb/drb'
  require 'tofu/proxy'
  
  tofu = Tofu::Bartender.new(YourTofuSession)
  DRb.start_service('druby://localhost:7642', tofu)
  while gets
    Div.reload_erb
  end
end
