require 'div'
require 'div/login'

require 'countlogin'
require 'guestlogin'

class SimpleLogin < Div::Login
  def initialize
    super
    @db = {'foo' => 'foo00', 'bar' => 'bar00'}
  end

  def get_user(user, pass)
    return nil if user.nil? || pass.nil?
    return nil unless @db[user] == pass
    user
  end
end

class SimpleLoginDiv < Div::LoginDiv
  set_erb('login.erb')
end

class BaseDiv < Div::Div
  set_erb('base.erb')

  def initialize(session)
    super(session)
    @contents = []
    # @contents.push(SimpleLoginDiv.new(session, session.login, session.hint))
    @contents.push(CountLoginDiv.new(session, session.login, session.hint))
    # @contents.push(GuestLoginDiv.new(session, session.login, session.hint))
    @contents.push(ExtendDiv.new(session))
  end
end

class ExtendDiv < Div::Div
  set_erb('extend.erb')

  def do_extend(context, params)
    min ,= params['min']
    return if min == ''
    min = min.to_i rescue 0
    @session.extend = min * 60
  end
end

class YourTofuSession < Div::TofuSession
  def initialize(bartender, hint=nil)
    super(bartender, hint)
    @login = SimpleLogin.new
    @base = BaseDiv.new(self)
    @extend = 5 * 60
  end
  attr_reader :login
  attr_accessor :extend

  def hint
    if @login.login? && !@login.guest?
      @login.name
    else
      super
    end
  end

  def expires
    Time.now + @extend
  end

  def do_GET(context)
    update_div(context)
    context.res_header('content-type', 'text/html; charset=euc-jp')
    context.res_body(@base.to_html(context))
  end
end

if __FILE__ == $0
  tofu = Tofu::Bartender.new(YourTofuSession)
  DRb.start_service('druby://localhost:12345', tofu)
  DRb.thread.join
end
