require 'thread'

class Board
  class Message
    def initialize(who, str)
      @who = who
      @when = Time.now
      @message = str
    end
    attr_reader :who, :when, :message
  end

  include Enumerable

  def initialize
    @list = []
    @mutex = Mutex.new
  end

  def add(who, str)
    msg = Message.new(who, str)
    @mutex.synchronize do
      @list.unshift(msg)
    end
    msg
  end
  
  def each(&block)
    @list.each(&block)
  end
end

  
