require 'div/div'
require 'div/tofusession'
require 'hako-div'

class BaseDiv < Div::Div
  set_erb('base.erb')

  def initialize(session)
    super(session)
    @hako = HakoDiv.new(session)
    @hako.show = true
  end
end

class YourTofuSession < Div::TofuSession
  def initialize(bartender, hint=nil)
    super(bartender, hint)
    @base = BaseDiv.new(self)
  end
  attr_reader :login

  def do_GET(context)
    update_div(context)
    context.res_header('content-type', 'text/html; charset=euc-jp')
    context.res_body(@base.to_html(context))
  end
end

if __FILE__ == $0
  require 'drb/drb'
  require 'tofu/proxy'

  unless $DEBUG
    # run as a daemon ...
    exit!(0) if fork
    Process.setsid
    exit!(0) if fork

    STDIN.reopen('/dev/null')
    STDOUT.reopen('/dev/null', 'w')
    STDERR.reopen('/dev/null', 'w')
  end

  use_ring = (ARGV.shift == '-r')

  tofu = Tofu::Bartender.new(YourTofuSession)
  if use_ring
    require 'rinda/ring'
    require 'tofu/ring'
    
    DRb.start_service

    ts = Rinda::RingFinger.primary

    th = Thread.new {
      finder = Tofu::RingTofuletFinder.new(ts)
      finder.mount('/hako', tofu)
    }

    DRb.thread.join
  else
    DRb.start_service('druby://localhost:7645', tofu)
    DRb.thread.join
  end
end
