require 'tofu/tofulet'
require 'drb/drb'

def setup_bartender(monolithic=true)
  if monolithic
    require 'yourapp'
    Tofu::Bartender.new(YourTofuSession)
  else
    DRbObject.new(nil, 'druby://localhost:7642')
  end
end


def main(monolithic=true)
  DRb.start_service

  logger = WEBrick::Log::new($stderr, WEBrick::Log::DEBUG)

  s = WEBrick::HTTPServer.new(:Port => 2000,
                             :AddressFamily => Socket::AF_INET,
                             :BindAddress => ENV['HOSTNAME'],
                             :Logger => logger)

  bartender = setup_bartender(monolithic)
  s.mount("/div", WEBrick::Tofulet, bartender)

  trap("INT"){ s.shutdown }
  s.start
end

main

