#!/usr/local/bin/ruby -Ke
require 'romkan'

class Aiura
  def initialize(boy, girl)
    @boy = boy
    @girl = girl
    @history = []
    setup
    run
  end
  attr_reader :boy, :girl
  attr_reader :boy_kana, :girl_kana
  attr_reader :history

  def kana_to_i(kana)
    vowel = kana.to_roma[-1,1]
    return 0 unless vowel.vowel? 
    return "aiueo".index(vowel) + 1
  end

  def str_to_a(str)
    kana = []
    ary = []
    str.to_kana.gsub(/\s/, '').scan(/./) do |ch|
      kana.push(ch)
      ary.push(kana_to_i(ch))
    end
    return kana, ary
  end
  
  def display(out=$stdout)
    out << @history[0].join("")
    out << "\n"
    (1...(@history.size)).each do |n|
      out << " " * n
      out << @history[n].join(" ")
      out << "\n"
    end
  end

  def result
    v = @history[-1].join("").to_i
    return 100 if v == 0
    v
  end

  private
  def setup
    m = str_to_a(@boy)
    f = str_to_a(@girl)
    @boy_kana = m[0].join("")
    @girl_kana = f[0].join("")
    @history[0] = m[0] + f[0]
    @history[1] = m[1] + f[1]
  end

  def run
    ary = @history[1]
    while ary.size > 2
      sz = ary.size - 1
      next_ary = Array.new(sz)
      sz.times do |n|
	next_ary[n] = (ary[n] + ary[n+1]) % 10
      end
      @history.push(next_ary)
      ary = next_ary
    end
  end
end

if __FILE__ == $0
  def main
    if ARGV.size >= 2
      boy = ARGV.shift
      girl = ARGV.shift
    else
      puts 'ȤΤΤʤޤ'
      boy = gets
      puts 'ʤΤΤʤޤ'
      girl = gets
    end
    
    aiura = Aiura.new(boy, girl)
    aiura.display
    print "#{aiura.boy_kana}  #{aiura.girl_kana} Τ礦 "
    print "#{aiura.result}% Ǥ\n"
  end
  
  main
end
