/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2008 David Zeuthen <davidz@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __DEVKIT_DAEMON_H__
#define __DEVKIT_DAEMON_H__

#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

#define DEVKIT_TYPE_DAEMON         (devkit_daemon_get_type ())
#define DEVKIT_DAEMON(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), DEVKIT_TYPE_DAEMON, DevkitDaemon))
#define DEVKIT_DAEMON_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), DEVKIT_TYPE_DAEMON, DevkitDaemonClass))
#define DEVKIT_IS_DAEMON(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), DEVKIT_TYPE_DAEMON))
#define DEVKIT_IS_DAEMON_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), DEVKIT_TYPE_DAEMON))
#define DEVKIT_DAEMON_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), DEVKIT_TYPE_DAEMON, DevkitDaemonClass))

typedef struct DevkitDaemonPrivate DevkitDaemonPrivate;

typedef struct
{
        GObject        parent;
        DevkitDaemonPrivate *priv;
} DevkitDaemon;

typedef struct
{
        GObjectClass   parent_class;
} DevkitDaemonClass;

typedef enum
{
        DEVKIT_DAEMON_ERROR_GENERAL,
        DEVKIT_DAEMON_ERROR_NOT_SUPPORTED,
        DEVKIT_DAEMON_ERROR_NO_SUCH_DEVICE,
        DEVKIT_DAEMON_NUM_ERRORS
} DevkitDaemonError;

#define DEVKIT_DAEMON_ERROR devkit_daemon_error_quark ()

GType devkit_daemon_error_get_type (void);
#define DEVKIT_DAEMON_TYPE_ERROR (devkit_daemon_error_get_type ())

GQuark        devkit_daemon_error_quark  (void);
GType         devkit_daemon_get_type     (void);
DevkitDaemon *devkit_daemon_new          (gboolean no_exit);

/* local methods */

struct DevkitDevice;
typedef struct DevkitDevice DevkitDevice;

void               devkit_daemon_inhibit_killtimer         (DevkitDaemon       *daemon);
void               devkit_daemon_uninhibit_killtimer       (DevkitDaemon       *daemon);
void               devkit_daemon_reset_killtimer           (DevkitDaemon       *daemon);

/* exported methods */

gboolean devkit_daemon_inhibit_shutdown  (DevkitDaemon          *daemon,
                                          DBusGMethodInvocation *context);

gboolean devkit_daemon_uninhibit_shutdown (DevkitDaemon          *daemon,
                                           const char            *cookie,
                                           DBusGMethodInvocation *context);

gboolean devkit_daemon_enumerate_by_subsystem  (DevkitDaemon           *daemon,
                                                const char            **subsystems,
                                                DBusGMethodInvocation  *context);

gboolean devkit_daemon_enumerate_by_native_path  (DevkitDaemon           *daemon,
                                                  const char            **subsystems,
                                                  DBusGMethodInvocation  *context);

G_END_DECLS

#endif /* __DEVKIT_DAEMON_H__ */
