/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/




#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: passwd.c,v 1.4 1994/08/11 20:51:01 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "Error.h"



int UserIDFromName(name)
     char *name;
{
  struct passwd *pw;
  int uid;

  if (name == NULL)
    {
      FatalError(E_BADUSERNAME,
		 "Attempt to get user id for NULL user name.\n");
    }

  if (PROGRAM_ErrorNo == E_NULL)
    {
      if (String_Comparator(name, "root") == 0)
	{
	  uid = 0;
	}
      else
	{
	  pw = getpwnam(name);
	  if (pw == NULL)
	    {
	      FatalError(E_BADUSERNAME,
			 "Could not get user id for user name %s.\n", name);
	    }
	  else
	    {
	      uid = pw->pw_uid;
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? uid : -1;
}



int GroupIDFromName(name)
          char *name;
{
  struct group *gr;
  int gid;

  if (name == NULL)
    {
      FatalError(E_BADGROUPNAME,
		 "Attempt to get user id for NULL user name.\n");
    }

  if (PROGRAM_ErrorNo == E_NULL)
    {
      gr = getgrnam(name);
      if (gr == NULL)
	{
	  FatalError(E_BADGROUPNAME,
		     "Could not get group id for group name %s.\n", name);
	} else {
	  gid = gr->gr_gid;
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? gid : -1;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/util/RCS/passwd.c,v $ */

