/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: TargetDB_Locate.c,v 1.4 1994/08/12 22:25:03 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"



TARGETDBENTRY *
TargetDB_LocateNode(targetdbp, pathtonode, flags)
     TARGETDB *targetdbp;
     char *pathtonode;
     unsigned short flags;
{
  register char **sp;

  TARGETDBENTRY *childnodep;
  char **targetpatharray;
  STRINGARRAY *targetpathstringarray;

  if (targetdbp == NULL) {
    if (flags & TDB_LAX) {
      childnodep = NULL;
    } else {
      FatalError(E_NULLTARGETDB,
		 "Attempt to locate node in NULL targetdb.\n");
    }
  }
  if (pathtonode == NULL) {
    FatalError(E_BADTARGETPATH,
	       "Attempt to locate node to NULL path in a targetdb.\n");
  }
  if ((PROGRAM_ErrorNo == E_NULL) && (targetdbp != NULL)) {
    /* split pathtonode into array of its components */
    if (PROGRAM_ErrorNo == E_NULL) {
      targetpathstringarray = StringToStringArray(pathtonode,
						  '/' /* delimited by /s */ ,
						  -1 /* no quotechar */ );
    }
    if (PROGRAM_ErrorNo == E_NULL) {
      if (targetpathstringarray == NULL) {
	targetpatharray = NULL;
      } else {
	targetpatharray = STRINGARRAY_Values(targetpathstringarray);
      }
    }
    childnodep = targetdbp;
    if ((PROGRAM_ErrorNo == E_NULL) && (targetpatharray != NULL)) {
      for (sp = targetpatharray;
	   (PROGRAM_ErrorNo == E_NULL) && (*sp != NULL);
	   sp++) {
	/* locate child node */
	childnodep = TargetDB_LocateChildNode(childnodep, *sp, flags);
      }
    }
    if ((PROGRAM_ErrorNo == E_NULL) && (targetpatharray != NULL))
      (void) StringArray_Free(targetpathstringarray);
  }
  return (PROGRAM_ErrorNo == E_NULL) ? childnodep : NULL;
}



int 
TargetDB_LocateIndexToChildNode(targetdbp, childname, flags)
     TARGETDB *targetdbp;
     char *childname;
     unsigned short flags;
{
  register unsigned int i;
  register TARGETDBENTRY **childp;
  register TARGETDBENTRY **fp, **tp;
  register unsigned int hi, lo;

  int ChildLocation;
  Boolean LocatedChild, PastChildLocation;
  int comparison;

  LocatedChild = FALSE;
  PastChildLocation = FALSE;
  ChildLocation = -1;

  if (targetdbp == NULL) {
    if (flags & TDB_LAX) {
      ChildLocation = -1;
    } else {
      FatalError(E_NULLTARGETDB,
		 "Attempt to locate child node of NULL targetdb entry.\n");
    }
  }
  if (childname == NULL) {
    FatalError(E_BADTARGETDBCHILDNAME,
	       "Attempt to locate child named NULL of a targetdb entry.\n");
  }
  if (targetdbp != NULL) {
    /* 
     * do a binary search with one exception -
     * since we will be appending to the end quite often, check the end first.
     */
    if (PROGRAM_ErrorNo == E_NULL) {
      if (TARGETDB_ChildCount(targetdbp) == 0) {
	ChildLocation = TARGETDB_ChildCount(targetdbp);
      } else {
	lo = 0;
	hi = TARGETDB_ChildCount(targetdbp) - 1;
	childp = TARGETDB_Children(targetdbp) + hi;
	comparison = String_Comparator(TARGETDB_Name(*childp), childname);
	if (comparison < 0) {
	  ChildLocation = hi + 1;
	} else if (comparison == 0) {
	  LocatedChild = TRUE;
	  ChildLocation = hi;
	} else {
	  /* node at hi always > childname */
	  while ((PROGRAM_ErrorNo == E_NULL)
		 && !LocatedChild && !PastChildLocation) {
	    if (hi == lo) {
	      PastChildLocation = TRUE;
	      ChildLocation = hi;
	    } else {
	      i = (hi + lo) / 2;
	      childp = TARGETDB_Children(targetdbp) + i;
	      comparison = String_Comparator(TARGETDB_Name(*childp),
					     childname);
	      if (comparison == 0) {
		LocatedChild = TRUE;
		ChildLocation = i;
	      } else if (comparison > 0) {
		hi = i;
	      } else {		/* comparison < 0 */
		lo = i + 1;
	      }
	    }
	  }
	}
      }
    }
    if (PROGRAM_ErrorNo == E_NULL) {
      if (!LocatedChild) {
	if (flags & TDB_CREATE) {
	  TARGETDB_ChildCount(targetdbp)++;
	  if (TARGETDB_ChildCount(targetdbp) == 1)
	    TARGETDB_Children(targetdbp)
	      = (TARGETDBENTRY **) emalloc(sizeof(TARGETDBENTRY *));
	  else
	    TARGETDB_Children(targetdbp)
	      = (TARGETDBENTRY **)
	      erealloc((void *) TARGETDB_Children(targetdbp),
		       TARGETDB_ChildCount(targetdbp)
		       * sizeof(TARGETDBENTRY *));
	  for (i = TARGETDB_ChildCount(targetdbp) - 1;
	       (PROGRAM_ErrorNo == E_NULL) && (i > ChildLocation);
	       i--) {
	    tp = TARGETDB_Children(targetdbp) + i;
	    fp = tp - 1;
	    *tp = *fp;
	  }
	  if (PROGRAM_ErrorNo == E_NULL) {
	    tp = TARGETDB_Children(targetdbp) + ChildLocation;
	    *tp = TargetDB_Create(childname /* name of child node */ ,
				  U_NULL /* update_spec */ ,
				  NULL /* file status */ ,
				  S_NULL /* status */ ,
				  NULL /* sourcelist */ ,
				  U_NULL /* update_spec_old */ ,
				  NULL /* old file status */ ,
				  0, NULL /* childcount,children */ );
	  }
	  if (PROGRAM_ErrorNo == E_NULL) {
	    LocatedChild = TRUE;
	  }
	} else if (flags & TDB_LAX) {
	  ChildLocation = -1;
	} else {
	  FatalError(E_NOSUCHTARGETDBCHILD,
		     "No child node named %s found.\n", childname);
	}
      }
    }
  }
  return ((PROGRAM_ErrorNo == E_NULL) && LocatedChild) ? ChildLocation : -1;
}



TARGETDB *
TargetDB_LocateChildNode(targetdbp, childname, flags)
     TARGETDB *targetdbp;
     char *childname;
     unsigned short flags;
{
  int index;
  TARGETDBENTRY *childnodep;

  index = TargetDB_LocateIndexToChildNode(targetdbp, childname, flags);

  if (PROGRAM_ErrorNo == E_NULL) {
    if (index < 0) {
      if (flags & TDB_LAX)
	childnodep = NULL;
      else {
	FatalError(E_NOSUCHTARGETDBCHILD,
		   "No entry named %s found in search for child node.\n",
		   childname);
      }
    } else
      childnodep = *(TARGETDB_Children(targetdbp) + index);
  }
  return (PROGRAM_ErrorNo == E_NULL) ? childnodep : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/015/src/lib/TargetDB/RCS/TargetDB_Locate.c,v $ */
