/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: Preference_Get.c,v 1.4 1994/08/19 20:46:39 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Preference.h"


int Preference_GetInt(prefdbp, item, prefname, prefdefaultval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     int prefdefaultval;
{
  PREFERENCE *pp;
  int prefval;

  pp = Preference_Lookup(prefdbp, item, prefname, FALSE/*Create*/);
  if ((PROGRAM_ErrorNo == E_NULL) && (pp == NULL))
    {
      if ((item != NULL) && (strcmp(item, PREF_WILDITEM) != 0))
	pp = Preference_Lookup(prefdbp, PREF_WILDITEM,prefname,FALSE/*Create*/);
    }

  if (PROGRAM_ErrorNo != E_NULL)
    {
      FatalError(E_PREFGETFAILED,
		 "Could not get preference %s for %s\n",
		 (item == NULL) ? "" : item, prefname);
    }
  else if (pp == NULL)
    prefval = prefdefaultval;
  else
    prefval = PREFERENCE_IVal(pp);

  return (PROGRAM_ErrorNo == E_NULL) ? prefval : PREFDEFAULT_INTEGER ;
}


unsigned Preference_GetUnsigned(prefdbp, item, prefname, prefdefaultval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     unsigned prefdefaultval;
{
  PREFERENCE *pp;
  unsigned prefval;

  pp = Preference_Lookup(prefdbp, item, prefname, FALSE/*Create*/);
  if ((PROGRAM_ErrorNo == E_NULL) && (pp == NULL))
    {
      if ((item != NULL) && (strcmp(item, PREF_WILDITEM) != 0))
	pp = Preference_Lookup(prefdbp, PREF_WILDITEM,prefname,FALSE/*Create*/);
    }

  if (PROGRAM_ErrorNo != E_NULL)
    {
      FatalError(E_PREFGETFAILED,
		 "Could not get preference %s for %s\n",
		 (item == NULL) ? "" : item, prefname);
    }
  else if (pp == NULL)
    prefval = prefdefaultval;
  else
    prefval = PREFERENCE_UVal(pp);

  return (PROGRAM_ErrorNo == E_NULL) ? prefval : PREFDEFAULT_UNSIGNED;
}


Boolean Preference_GetBoolean(prefdbp, item, prefname, prefdefaultval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     Boolean prefdefaultval;
{
  PREFERENCE *pp;
  Boolean prefval;

  pp = Preference_Lookup(prefdbp, item, prefname, FALSE/*Create*/);
  if ((PROGRAM_ErrorNo == E_NULL) && (pp == NULL))
    {
      if ((item != NULL) && (strcmp(item, PREF_WILDITEM) != 0))
	pp = Preference_Lookup(prefdbp, PREF_WILDITEM,prefname,FALSE/*Create*/);
    }

  if (PROGRAM_ErrorNo != E_NULL)
    {
      FatalError(E_PREFGETFAILED,
		 "Could not get preference %s for %s\n",
		 (item == NULL) ? "" : item, prefname);
    }
  else if (pp == NULL)
    prefval = prefdefaultval;
  else
    prefval = PREFERENCE_BoolVal(pp);

  return (PROGRAM_ErrorNo == E_NULL) ? prefval : PREFDEFAULT_BOOLEAN;
}


char *Preference_GetString(prefdbp, item, prefname, prefdefaultval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     char *prefdefaultval;
{
  PREFERENCE *pp;
  char *strval;
  char *prefval;

  pp = Preference_Lookup(prefdbp, item, prefname, FALSE/*Create*/);
  if ((PROGRAM_ErrorNo == E_NULL) && (pp == NULL))
    {
      if ((item != NULL) && (strcmp(item, PREF_WILDITEM) != 0))
	pp = Preference_Lookup(prefdbp, PREF_WILDITEM,prefname,FALSE/*Create*/);
    }
  
  if (PROGRAM_ErrorNo != E_NULL)
    {
      FatalError(E_PREFGETFAILED,
		 "Could not get preference %s for %s\n",
		 (item == NULL) ? "" : item, prefname);
    }
  else if (pp == NULL)
    strval = prefdefaultval;
  else
    strval = PREFERENCE_StrVal(pp);

  if (PROGRAM_ErrorNo == E_NULL)
    { prefval = (strval == NULL) ?  NULL : String(strval, strlen(strval)); }

  return (PROGRAM_ErrorNo == E_NULL) ? prefval : PREFDEFAULT_STRING;
}


STRINGARRAY *Preference_GetStringArray(prefdbp, item, prefname, prefdefaultval, alloc)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     STRINGARRAY *prefdefaultval;
     Boolean alloc;
{
  PREFERENCE *pp;
  STRINGARRAY *strarrval;
  STRINGARRAY *prefval;

  pp = Preference_Lookup(prefdbp, item, prefname, FALSE/*Create*/);
  if ((PROGRAM_ErrorNo == E_NULL) && (pp == NULL))
    {
      if ((item != NULL) && (strcmp(item, PREF_WILDITEM) != 0))
	pp = Preference_Lookup(prefdbp, PREF_WILDITEM,prefname,FALSE/*Create*/);
    }

  if (PROGRAM_ErrorNo != E_NULL)
    {
      FatalError(E_PREFGETFAILED,
		 "Could not get preference %s for %s\n",
		 (item == NULL) ? "" : item, prefname);
    }
  else if (pp == NULL)
    strarrval = prefdefaultval;
  else
    strarrval = PREFERENCE_StrArrVal(pp);

  if (PROGRAM_ErrorNo == E_NULL) {
    if (alloc)
    {
      prefval = (strarrval == NULL) ?
	NULL : StringArray(strarrval, StringArray_Size(strarrval));
    } else {
      prefval = strarrval;
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? prefval : PREFDEFAULT_STRINGARRAY;
}


STRINGSET *Preference_GetStringSet(prefdbp, item, prefname, prefdefaultval, alloc)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     STRINGSET *prefdefaultval;
     Boolean alloc;
{
  PREFERENCE *pp;
  STRINGSET *strsetval;
  STRINGSET *prefval;

  pp = Preference_Lookup(prefdbp, item, prefname, FALSE/*Create*/);
  if ((PROGRAM_ErrorNo == E_NULL) && (pp == NULL))
    {
      if ((item != NULL) && (strcmp(item, PREF_WILDITEM) != 0))
	pp = Preference_Lookup(prefdbp, PREF_WILDITEM,prefname,FALSE/*Create*/);
    }

  if (PROGRAM_ErrorNo != E_NULL)
    {
      FatalError(E_PREFSETFAILED,
		 "Could not get preference %s for %s\n",
		 (item == NULL) ? "" : item, prefname);
    }
  else if (pp == NULL)
    strsetval = prefdefaultval;
  else
    strsetval = PREFERENCE_StrSetVal(pp);

  if (PROGRAM_ErrorNo == E_NULL) {
    if (alloc) {
      prefval = (strsetval == NULL) ?
	NULL : StringArray(strsetval, StringArray_Size(strsetval));
    } else {
      prefval = strsetval;
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? prefval : PREFDEFAULT_STRINGSET;
}


SENTENCE *Preference_GetSentence(prefdbp, item, prefname, prefdefaultval)
     PREFERENCEDB *prefdbp;
     char *item, *prefname;
     SENTENCE *prefdefaultval;
{
  PREFERENCE *pp;
  SENTENCE *sentenceval;
  SENTENCE *prefval;

  pp = Preference_Lookup(prefdbp, item, prefname, FALSE/*Create*/);
  if ((PROGRAM_ErrorNo == E_NULL) && (pp == NULL))
    {
      if ((item != NULL) && (strcmp(item, PREF_WILDITEM) != 0))
	pp = Preference_Lookup(prefdbp, PREF_WILDITEM,prefname,FALSE/*Create*/);
    }

  if (PROGRAM_ErrorNo != E_NULL)
    {
      FatalError(E_PREFSETFAILED,
		 "Could not get preference %s for %s\n",
		 (item == NULL) ? "" : item, prefname);
    }
  else if (pp == NULL)
    sentenceval = prefdefaultval;
  else
    sentenceval = PREFERENCE_SentenceVal(pp);

  if (PROGRAM_ErrorNo == E_NULL)
    {
      prefval = (sentenceval == NULL) ?
	NULL : StringArray(sentenceval, StringArray_Size(sentenceval));
    }

  return (PROGRAM_ErrorNo == E_NULL) ? prefval : PREFDEFAULT_SENTENCE;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Preference/RCS/Preference_Get.c,v $ */
