/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: Preference_Depot.c,v 1.4 1994/08/12 22:12:21 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Preference.h"


Boolean Preference_Universal(optionid)
     int optionid;
{
  Boolean Universal;
  char *pname;

  pname = Preference_OptionName(optionid);
  if (!strcmp(pname, "ignore")
      || !strcmp(pname, "specialfile")
      || !strcmp(pname, "usemodtimes"))
    Universal = TRUE;
  else
    Universal = FALSE;

  return (PROGRAM_ErrorNo == E_NULL) ? Universal : FALSE;
}

Boolean Preference_CollectionOperand(optionid)
     int optionid;
{
  Boolean CollectionOperand;
  char *pname;

  pname = Preference_OptionName(optionid);
  if (!strcmp(pname, "hintfile")
      || !strcmp(pname, "override")
      || !strcmp(pname, "path")
      || !strcmp(pname, "searchpath")
      || !strcmp(pname, "version"))
    CollectionOperand = TRUE;
  else
    CollectionOperand = FALSE;

  return (PROGRAM_ErrorNo == E_NULL) ? CollectionOperand : FALSE;
}


Boolean Preference_TargetOperand(optionid)
     int optionid;
{
  Boolean TargetOperand;

  /* no target operands */
  TargetOperand = FALSE;

  return (PROGRAM_ErrorNo == E_NULL) ? TargetOperand : FALSE;
}


Boolean Preference_CommandOperand(optionid)
     int optionid;
{
  Boolean CommandOperand;
  char *pname;

  pname = Preference_OptionName(optionid);
  if (!strcmp(pname, "command")
      || !strcmp(pname, "target.command"))
    CommandOperand = TRUE;
  else
    CommandOperand = FALSE;

  return (PROGRAM_ErrorNo == E_NULL) ? CommandOperand : FALSE;
}


Boolean Preference_CollectionValue(optionid)
          int optionid;
{
  Boolean CollectionValue;
  char *pname;

  pname = Preference_OptionName(optionid);
  if (!strcmp(pname, "collection.installmethod")
      || !strcmp(pname, "ignore")
      || !strcmp(pname, "override"))
    CollectionValue = TRUE;
  else
    CollectionValue = FALSE;

  return (PROGRAM_ErrorNo == E_NULL) ? CollectionValue : FALSE;
}


Boolean Preference_TargetValue(optionid)
     int optionid;
{
  Boolean TargetValue;
  char *pname;

  pname = Preference_OptionName(optionid);
  if (!strcmp(pname, "target.command")
      || !strcmp(pname, "target.installmethod")
      || !strcmp(pname, "target.modemask")
      || !strcmp(pname, "target.owner")
      || !strcmp(pname, "target.group")
      || !strcmp(pname, "target.setgid")
      || !strcmp(pname, "target.setuid")
      || !strcmp(pname, "specialfile"))
    TargetValue = TRUE;
  else
    TargetValue = FALSE;

  return (PROGRAM_ErrorNo == E_NULL) ? TargetValue : FALSE;
}


/*
 * Cheap, fast, incorrect and overdoing it.
 * Fine tune to choose specific changed targets from the target values.
 * $$$FINETUNE$$$
 */
STRINGSET *PreferenceDiff_GetChangedTargets(prefdiffp)
     PREFERENCE ***prefdiffp;
{
  register int i;
  register PREFERENCE ***prefpairp;
  register PREFERENCE **pp;
  
  STRINGSET *changedtargetset;

  changedtargetset = NULL;
  if (prefdiffp != NULL)
    {
      for (prefpairp = prefdiffp;
	   (PROGRAM_ErrorNo == E_NULL) && (*prefpairp != NULL);
	   prefpairp++)
	{
	  /* get the operand from any item of the pair, if neeeded */
	  pp = *prefpairp; if (*pp == NULL) pp++;

	  if ((pp != NULL) && (*pp != NULL)
	      && (Preference_TargetOperand(PREFERENCE_OptionID(*pp)))
	      && (PREFERENCE_Operand(*pp) != NULL))
	    {
	      changedtargetset
		= StringSet_AddString(changedtargetset,PREFERENCE_Operand(*pp));
	    }

	  /* get the values from both items of the pair */
	  for (i = 0, pp = *prefpairp;
	       (PROGRAM_ErrorNo == E_NULL) && (i < 2);
	       i++, pp++)
	    {
	      if ((pp != NULL) && (*pp != NULL)
		  && (Preference_TargetValue(PREFERENCE_OptionID(*pp)))
		  && (PREFERENCE_StrSetVal(*pp) != NULL))
		{
		  changedtargetset
		    = StringSet_Merge(changedtargetset,
				      PREFERENCE_StrSetVal(*pp));
		}
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? changedtargetset : NULL;
}



STRINGSET *PreferenceDiff_GetChangedCommands(prefdiffp)
     PREFERENCE ***prefdiffp;
{
  register PREFERENCE ***prefpairp;
  register PREFERENCE **pp;

  STRINGSET *changedcommandset;

  changedcommandset = NULL;
  if (prefdiffp != NULL)
    {
      for (prefpairp = prefdiffp;
	   (PROGRAM_ErrorNo == E_NULL) && (*prefpairp != NULL);
	   prefpairp++)
	{
	  /* get the operand from any item of the pair, if neeeded */
	  pp = *prefpairp; if (*pp == NULL) pp++;

	  if ((pp != NULL) && (*pp != NULL)
	      && (Preference_CommandOperand(PREFERENCE_OptionID(*pp)))
	      && (PREFERENCE_Operand(*pp) != NULL))
	    {
	      changedcommandset
		=StringSet_AddString(changedcommandset,PREFERENCE_Operand(*pp));
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? changedcommandset : NULL;
}


/*
 * Cheap, fast, incorrect.
 * Fine tune to choose disjoint unions of values.
 * Rerefine function to determine preference-specific values.
 * $$$FINETUNE$$$
 */
STRINGSET *PreferenceDiff_GetChangedCollections(prefdiffp)
          PREFERENCE ***prefdiffp;
{
  register int i;
  register PREFERENCE ***prefpairp;
  register PREFERENCE **pp;

  STRINGSET *changedcollectionset;

  changedcollectionset = NULL;
  if (prefdiffp != NULL)
    {
      for (prefpairp = prefdiffp;
	   (PROGRAM_ErrorNo == E_NULL) && (*prefpairp != NULL);
	   prefpairp++)
	{
	  /* get the operand from any item of the pair, if neeeded */
	  pp = *prefpairp; if (*pp == NULL) pp++;

	  if ((pp != NULL) && (*pp != NULL)
	      && (Preference_CollectionOperand(PREFERENCE_OptionID(*pp)))
	      && (PREFERENCE_Operand(*pp) != NULL))
	    {
	      changedcollectionset
		= StringSet_AddString(changedcollectionset,
				      PREFERENCE_Operand(*pp));
	    }

	  /* get the values from both items of the pair */
	  for (i = 0, pp = *prefpairp;
	       (PROGRAM_ErrorNo == E_NULL) && (i < 2);
	       i++, pp++)
	    {
	      if ((pp != NULL) && (*pp != NULL)
		  && (Preference_CollectionValue(PREFERENCE_OptionID(*pp)))
		  && (PREFERENCE_StrSetVal(*pp) != NULL))
		{
		  changedcollectionset
		    = StringSet_Merge(changedcollectionset,
				      PREFERENCE_StrSetVal(*pp));
		}
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? changedcollectionset : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Preference/RCS/Preference_Depot.c,v $ */
