/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: HintService_UnsetRelatedHints.c,v 1.4 1995/05/10 21:22:15 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"
#include "HintService.h"


static Boolean HintService_WriteHintsToLocation();
static void HintService_WriteToFile();


/*
 * CAVEAT : This is only a temporary function to get hint functionality working
 * Right now, the hintlocation must contain a file, else an error results.
 */
Boolean 
HintService_UnsetRelatedHints(pathprefix, hintlocation)
     char *pathprefix;
     char *hintlocation;
{
  register HINTDB hpp;

  HINTDB hintdb;
  HINTDB relatedhintdb;

  hintdb = HintService_GetRelatedHints("" /* pathprefix */ , hintlocation);
  if (PROGRAM_ErrorNo == E_NULL)
    relatedhintdb = HintDB_GetRelatedHints(hintdb, pathprefix);
  if ((PROGRAM_ErrorNo == E_NULL) && (relatedhintdb != NULL)) {
    for (hpp = relatedhintdb;
	 (PROGRAM_ErrorNo == E_NULL) && (*hpp != NULL);
	 hpp++) {
      if (HINT_UniqueID(*hpp) != NULL) {
	(void) free((void *) HINT_UniqueID(*hpp));
	HINT_UniqueID(*hpp) = NULL;
	hintdb = HintDB_InsertHint(hintdb, *hpp, TRUE /* OverWrite */ );
      }
    }
    if (PROGRAM_ErrorNo == E_NULL)
      (void) HintService_WriteHintsToLocation(hintdb, hintlocation);
  }
  return (PROGRAM_ErrorNo == E_NULL) ? TRUE : FALSE;
}


static Boolean 
HintService_WriteHintsToLocation(hintdb, hintlocation)
     HINTDB hintdb;
     char *hintlocation;
{
  FILE *hintfd;

  hintfd = efopen(hintlocation, "w");
  if (PROGRAM_ErrorNo == E_NULL) {
    HintService_WriteToFile(hintfd, hintdb);
    fclose(hintfd);
  }
  return (PROGRAM_ErrorNo == E_NULL) ? TRUE : FALSE;
}


static void 
HintService_WriteToFile(out, hintdb)
     FILE *out;
     HINTDB hintdb;
{
  register HINTDB hp;

  if (hintdb != NULL) {
    for (hp = hintdb; *hp != NULL; hp++) {
      if (HINT_PathName(*hp) == E_NULL) {
	FatalError(E_PATHLESSHINT, "Hint found for NULL path\n");
      } else {
	fprintf(out, "PATH %s\nID %s\nMODTIME %d\n",
		HINT_PathName(*hp), HINT_UniqueID(*hp),
		HINT_ModTime(*hp));
      }
    }
  }
  return;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/020/src/lib/HintService/RCS/HintService_UnsetRelatedHints.c,v $  */
