/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef _DEPOT_HINT_H
#define _DEPOT_HINT_H

/* $Id: Hint.h,v 1.4 1994/09/14 14:56:45 ww0r Exp $ */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

typedef struct Hint
{
  char *pathname;
  char *uniqueid;
  time_t modtime;
} HINT;

typedef HINT **HINTDB;

#define HINT_PathName(hp) ((hp)->pathname)
#define HINT_UniqueID(hp) ((hp)->uniqueid)
#define HINT_ModTime(hp) ((hp)->modtime)

#define HINT_DefaultID "unix"


extern HINTDB HintDB_Read();
extern int HintDB_Write();

extern HINTDB Hint_CollectAllHints();
extern HINTDB Hint_CollectPathHints();

extern HINT *HintDB_GetHint();
extern HINTDB HintDB_GetRelatedHints();
extern HINTDB HintDB_InsertHint();
extern HINTDB HintDB_MergeHintDB();

extern HINTDB HintDB_SetPathPrefix();
extern HINTDB HintDB_UnsetPathPrefix();

extern HINT *Hint_Create();
extern unsigned int HintDB_Size();
extern Boolean Hint_Comparator();
extern Boolean HintDB_Comparator();
extern void Hint_Free();
extern void HintDB_Free();

#endif /* _DEPOT_HINT_H */
/* $Source: /afs/andrew/system/src/local/depot2/013/src/lib/Hint/RCS/Hint.h,v $ */
