/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: FileSystemImage_Write.c,v 1.6 1994/12/08 15:47:05 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 *
 * Author: Chris Newman
 *         Modified by Sohan C. Ramakrishna Pillai for depot
 *
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"

/* write a node in the tree
 */
static void FileSystemImage_TreeWrite(out, node, level)
    FILE *out;
    treenode *node;
    int level;
{

    if (node != NULL) {
      /* print name & type */
      (void)quotedfputs(FILESYSTEMIMAGE_Name(node), ' ', out);
      fprintf(out, " %d",
	      FILESYSTEMIMAGE_Type(node));

      /* print rest of info */
      if (FILESYSTEMIMAGE_Type(node) & FS_SYMLNK) {
	putc(' ', out);
	putc(FSINFO_LINK, out);
	fputs(FILESYSTEMIMAGE_Link(node), out);
      } else { /* !symlink */
	if (FILESYSTEMIMAGE_Link(node) != NULL) {
	  if (FILESYSTEMIMAGE_Type(node) & FS_FSMOUNT) {
	    putc(' ', out);
	    putc(FSINFO_FSMT, out);
	    fputs(FILESYSTEMIMAGE_FSMountID(node), out);
	  } else {
	    putc(' ', out);
	    putc(FSINFO_LINK, out);
	    fputs(FILESYSTEMIMAGE_Link(node), out);
	  }
	}
	if (FILESYSTEMIMAGE_Type(node) & FS_DIR) {
	  putc(' ', out);
	  putc(FSINFO_DIRTIME, out);
	  fprintf(out, "%d", FILESYSTEMIMAGE_DTime(node));
	}
	putc(' ', out);
	putc(FSINFO_MODE, out);
	fprintf(out, "%o ", FILESYSTEMIMAGE_Mode(node));
	putc(FSINFO_SIZE, out);
	fprintf(out, "%d ",FILESYSTEMIMAGE_Size(node));
	putc(FSINFO_MODTIME, out);
	fprintf(out, "%d", FILESYSTEMIMAGE_MTime(node));

	if (FILESYSTEMIMAGE_Uid(node)) {
	  putc(' ', out);
	  putc(FSINFO_UID, out);
	  fprintf(out, "%d", FILESYSTEMIMAGE_Uid(node));
	}
	if (FILESYSTEMIMAGE_Gid(node)) {
	  putc(' ', out);
	  putc(FSINFO_GID, out);
	  fprintf(out, "%d", FILESYSTEMIMAGE_Gid(node));
	}
	if (FILESYSTEMIMAGE_Count(node)) {
	  putc(' ', out);
	  putc(FSINFO_COUNT, out);
	  fprintf(out, "%d", FILESYSTEMIMAGE_Count(node));
	}
      }
      putc('\n', out);

      /* walk through directory */
      for (node = FILESYSTEMIMAGE_Child(node);
	   node != NULL;
	   node = FILESYSTEMIMAGE_Next(node))
	FileSystemImage_TreeWrite(out, node, level + 1);
    }
}

/* count the number of nodes in a tree
 */
static int nodecount(node)
    treenode *node;
{
    int cnt = 1;

    if (node != NULL) {
      for (node = FILESYSTEMIMAGE_Child(node);
	   node != (treenode *) NULL;
	   node = FILESYSTEMIMAGE_Next(node))
	cnt += nodecount(node);
    }

    return (cnt);
}

/* output the quickref file for a given directory
 */
void FileSystemImage_Write(out, node)
    FILE *out;
    treenode *node;
{
  if (PROGRAM_ErrorNo != E_NULL)
    return;
  fprintf(out, "%s V1.0\n", FILESYSTEMIMAGE_magic);
  if (node != NULL) {
    fprintf(out, "%d\n", nodecount(node));
    FileSystemImage_TreeWrite(out, node, 0);
  }
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/017/src/lib/FileSystemImage/RCS/FileSystemImage_Write.c,v $ */
