/***********************************************************
        Copyright 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#if !defined(SABER) && !defined(LINT)
static char rcs_id[]="$Id: File_Busy.c,v 1.5 1994/09/02 19:43:36 ww0r Exp $";
#endif /* SABER && LINT */

/*
 * Author: Walter C. Wong
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"

/* internal depot routine to generate a unique filename */

char *
_genbusy_name(old_name)
  char *old_name;
{
#define BUSYTXT "-BUSYFILE"
#define BUSYLEN 9 /* BUSYLEN == strlen("-BUSYFILE"); */

  static char buf[MAXPATHLEN+BUSYLEN+20]; 
          /* 10 == busy text, 20 == overallocated for time val  + NULL*/
  unsigned int namelen = strlen(old_name);
  unsigned int busyidx;
  
  if (namelen >= MAXPATHLEN) {
    FatalError(E_NAMETOOLONG, "Filename %s is too long.\n", old_name);
    return(NULL);
  }

  busyidx = namelen - BUSYLEN;
  if ((busyidx > 0) && (strcmp((old_name+busyidx), BUSYTXT) == 0)) {
    /* file already has a -BUSY extention. leave it alone. */
    return NULL;
  }

  (void)sprintf(buf,"%s.%d", old_name, time(NULL));
  (void)strcat(buf, BUSYTXT);

  /* re-use namelen */
  namelen = strlen(buf);
  if (namelen > (MAXPATHLEN-1)) {
    FatalError(E_NAMETOOLONG, 
	       "Path name + busy file extention is too long.\n");
    /* XXX: We should try to recover but if a file is 17 characters away
     *     from MAXPATHNAMELEN, something is probably broken already.
     */
  }
  return(buf);
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/012/src/lib/FileOps/RCS/File_Busy.c,v $ */
