/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef _DEPOT_DEPOTDB_H
#define _DEPOT_DEPOTDB_H

/* $Id: DepotDB.h,v 1.3 1994/08/12 13:54:23 ww0r Exp $ */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#define DEPOTDBVERSIONSTRING	"DepotDBVersion-1.0"

typedef struct DepotDB
{
  PREFERENCEDB *preferencedb;
  DEPOTCONFDB *depotconfdb;
  COLLECTIONLIST *collectionlist;
  TARGETDB *targetdb;
  PREFERENCEDB *preferencedb_old;
  DEPOTCONFDB *depotconfdb_old;
  COLLECTIONLIST *collectionlist_old;
} DEPOTDB;

#define DEPOTDB_PreferenceDB(dp) ((dp)->preferencedb)
#define DEPOTDB_DepotConfDB(dp) ((dp)->depotconfdb)
#define DEPOTDB_CollectionList(dp) ((dp)->collectionlist)
#define DEPOTDB_TargetDB(dp) ((dp)->targetdb)
#define DEPOTDB_OldPreferenceDB(dp) ((dp)->preferencedb_old)
#define DEPOTDB_OldDepotConfDB(dp) ((dp)->depotconfdb_old)
#define DEPOTDB_OldCollectionList(dp) ((dp)->collectionlist_old)


typedef struct DepotDBHandle
{
  FILE *fp;
  unsigned int offset[4];
} DEPOTDBHANDLE;

#define DEPOTDBHANDLE_FP(dbh)		        ((dbh)->fp)
#define DEPOTDBHANDLE_OFF_PREFERENCE(dbh)	((dbh)->offset[0])
#define DEPOTDBHANDLE_OFF_DEPOTCONF(dbh)	((dbh)->offset[1])
#define DEPOTDBHANDLE_OFF_COLLECTIONLIST(dbh)	((dbh)->offset[2])
#define DEPOTDBHANDLE_OFF_TARGET(dbh)		((dbh)->offset[3])

extern DEPOTDBHANDLE *DepotDB_Open();
extern int DepotDB_Close();
extern DEPOTDB *DepotDB_Read();
extern int DepotDB_Write();

extern DEPOTDB *DepotDB_ReadPreliminaryInfo();

extern PREFERENCEDB *DepotDB_PreferenceDB_Read();
extern DEPOTCONFDB *DepotDB_DepotConfDB_Read();
extern TARGETDB *DepotDB_TargetDB_Read();
extern COLLECTIONLIST *DepotDB_CollectionList_Read();


#endif /* _DEPOT_DEPOTDB_H */
