/***********************************************************
        Copyright 1991 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/



%{


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: GlobalDepotConf_Read.y,v 1.4 1994/07/08 01:41:23 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "DepotConf.h"

DEPOTCONFDB *yyDB;
extern int yylineno;

#define dbgprintf(x) /* fprintf x */

%}

%union
{
  int	ival;
  unsigned unsval;
  Boolean boolval;
  char	chrval;
  char *strval;
  STRINGARRAY *strarrval;
}

%token <strval> COLLECTION
%token <strval> SOURCE
%token <strval> TARGET
%token <strval> COMMANDLABEL
%token <intval> MAPPING
%token <intval> DELETE
%token <intval> COMMAND
%token <intval> DELETECOMMAND
%token <intval> UNKSPEC
%token <strval> STRING
%token <ival> COMMENT
%token <ival> NEWLINE

%type <ival> input
%type <ival> entry
%type <ival> Specification
%type <strarrval> TargetList

%%	 /* rules */


input	 :	/* empty */
			{
			  $$ = 0;
			}
	|	input line
			{
			  $$ = $1;
			}
	;


line    :       NEWLINE |  entry NEWLINE | entry;

entry	:	COMMENT
			{
			  dbgprintf((stdout, "COMMENT\n"));
			  $$ = 0;
			}
	|	Specification
			{
			  dbgprintf((stdout, "Specification\n"));
			  $$ = $1;
			}
	;

Specification:	COLLECTION SOURCE
			{
			  dbgprintf((stdout, "MAPPING\n"));
			  yyDB =
			    DepotConfDB_Map(yyDB, $1, $2, $2);
			  String_Free($1);
			  String_Free($2);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	COLLECTION SOURCE TARGET
			{
			  dbgprintf((stdout, "MAPPING\n"));
			  yyDB =
			    DepotConfDB_Map(yyDB, $1, $2, $3);
			  String_Free($1);
			  String_Free($2); String_Free($3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	COLLECTION MAPPING SOURCE
			{
			  dbgprintf((stdout, "MAPPING\n"));
			  yyDB =
			    DepotConfDB_Map(yyDB, $1, $3, $3);
			  String_Free($1);
			  String_Free($3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	COLLECTION MAPPING SOURCE TARGET
			{
			  dbgprintf((stdout, "MAPPING\n"));
			  yyDB =
			    DepotConfDB_Map(yyDB, $1, $3, $4);
			  String_Free($1);
			  String_Free($3); String_Free($4);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	COLLECTION DELETE TARGET
			{
			  dbgprintf((stdout, "DELETE\n"));
			  yyDB =
			    DepotConfDB_Delete(yyDB, $1, $3);
			  String_Free($1);
			  String_Free($3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	COLLECTION COMMAND COMMANDLABEL TargetList
			{
			  dbgprintf((stdout, "COMMAND\n"));
			  yyDB =
			    DepotConfDB_Command(yyDB, $1, $3, $4);
			  String_Free($1);
			  String_Free($3); StringArray_Free($4);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	COLLECTION DELETECOMMAND COMMANDLABEL
			{
			  dbgprintf((stdout, "DELETECOMMAND\n"));
			  yyDB =
			    DepotConfDB_DeleteCommand(yyDB, $1, $3);
			  String_Free($1);
			  String_Free($3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


TargetList:	/* empty */
			{
			  dbgprintf((stdout, "NULL TARGET\n"));
			  $$ = NULL;
			}
	|	TargetList TARGET
			{
			  dbgprintf((stdout, "TARGET\n"));
			  $$ = StringArray_AppendString($1, $2);
			  String_Free($2);
			}
	;


%%

yyerror(str)
     char *str;
{
  FatalError(E_GLBLDEPOTCONFPARSE,
	     "Error parsing global depot.conf: %s: line %d\n", str, yylineno);
}


yywrap()
{ return 1; }


DEPOTCONFDB *GlobalDepotConfDB_Read(fp)
     FILE *fp;
{
  extern FILE *yyin;

  yyDB = (DEPOTCONFDB *)emalloc(sizeof(DEPOTCONFDB));
  if (PROGRAM_ErrorNo == E_NULL)
    *yyDB = NULL;

  yyin = fp;
  yylineno = 1;
  yyclearin;
  yyparseinit();

  if ((PROGRAM_ErrorNo == E_NULL) && (yyparse() < 0))
    {
      FatalError(E_GLBLDEPOTCONFPARSE,
		 "Error parsing global depot.conf file\n");
    }

  return (PROGRAM_ErrorNo == E_NULL) ? yyDB : NULL;
}


/*
 * $Log: GlobalDepotConf_Read.y,v $
 * Revision 1.4  1994/07/08  01:41:23  ww0r
 * handle EOF before \n
 * initialize parser state on each invocation of the procedure
 *
 * Revision 1.3  1994/07/07  17:00:24  ww0r
 * change rcs header to rcs id
 * be more verbose on errors
 * reset line count
 *
 * Revision 1.2  1994/04/07  15:38:47  ww0r
 * - header consolidation into depotlib.h
 * - use installed headers
 *
 * Revision 1.1  1993/06/29  20:17:27  sohan
 * Initial revision
 *
 *
 */
