/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: CollectionList_Write.c,v 1.4 1994/08/12 03:30:12 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "Hint.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"

static char CollectionSpecialChars[] =
{
  ' ', '\t', '\n',  '\'', '\"', '\\',
  '\0'
};

static int NCollectionSpecialChars =
    sizeof(CollectionSpecialChars)/
    sizeof(CollectionSpecialChars[0]) - 1;


static unsigned int CollectionList_CollectionCount();


static unsigned int CollectionList_CollectionCount(clistp)
     COLLECTIONLIST *clistp;
{
   register unsigned int i;
   register COLLECTION *cp;
   register unsigned int count;

   if (clistp == NULL)
     {
       FatalError(E_NULLCOLLECTIONLIST,
		  "Attempt to count collections in NULL collection list.\n");
     }

   i = 0; count = 0;
   while (i < COLLECTIONLIST_Size(clistp))
     {
       cp = COLLECTIONLIST_Collection(clistp, i);
       if ((cp != NULL)
	   && !(COLLECTION_Status(cp) & (C_DELETE|C_IGNORE|C_NONEXISTENT)))
	 count++;
       i++;
     }

   return (PROGRAM_ErrorNo == E_NULL)? count : 0;
}



int CollectionList_Write(fp, clistp)
     FILE *fp;
     COLLECTIONLIST *clistp;
{
  register unsigned int i;
  register COLLECTION *cp;
  register unsigned int ncollections;

  if (clistp == NULL)
    {
      FatalError(E_NULLCOLLECTIONLIST,
		 "Attempt to write NULL collection list.\n");
    }

  ncollections = CollectionList_CollectionCount(clistp);
  fprintf(fp, "%d %d\n", COLLECTIONLIST_Size(clistp), ncollections);

  i = 0;
  while ( (PROGRAM_ErrorNo == E_NULL)
	 && (i < COLLECTIONLIST_Size(clistp)))
    {
      cp = COLLECTIONLIST_Collection(clistp, i);
      if ((cp != NULL)
	  && !(COLLECTION_Status(cp) & (C_DELETE|C_IGNORE|C_NONEXISTENT)))
	{
	  fprintf(fp, "%d ", i);
	  if (COLLECTION_Name(cp) == NULL)
	    {
	      FatalError(E_BADCOLLECTIONLIST,
			 "Collection with no name in collection list.\n");
	    }
	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      String_Write(fp, COLLECTION_Name(cp),
			   '\\', ' ',
			   CollectionSpecialChars, NCollectionSpecialChars);
	    }
	  /* leave a space */
	  putc(' ', fp);
	  if (COLLECTION_Path(cp) == NULL)
	    {
	      FatalError(E_BADCOLLECTIONLIST,
			 "Collection with no path in collection list.\n");
	    }
	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      String_Write(fp, COLLECTION_Path(cp),
			   '\\', ' ',
			   CollectionSpecialChars, NCollectionSpecialChars);
	    }
	  putc('\n', fp);
	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      if (COLLECTION_CommandList(cp) == NULL)
		{ putc('0', fp); }
	      else
		{
		  fprintf(fp, "%d\n",
			  StringArray_Size(COLLECTION_CommandList(cp)));
		  StringArray_Write(fp, COLLECTION_CommandList(cp),
				    '\\', ' ',
				    NULL, 0 /* special chars, count */);
		}
	    }
	  putc('\n', fp);
	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      if (COLLECTION_DepotConfDB(cp) != NULL)
		{
		  CollectionDepotConfDB_Write(fp, COLLECTION_DepotConfDB(cp));
		}
	    }
	  (void)putc(0, fp); /* write a NUL */
	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      (void)HintDB_Write(fp, COLLECTION_HintDB(cp));
	    }
	}
      i++;
    }

  return (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
}


/* $Source: /afs/andrew/system/src/local/depot2/012/src/lib/CollectionList/RCS/CollectionList_Write.c,v $ */
