/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: Collection_TargetSource.c,v 1.5 1994/08/12 03:24:14 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"



/*
 * add source to the source list of an entry in a collection's target database.
 * Strategy: Check conflicts and order sources according to updates as follows:
 *	(U_MAP or U_HARDLINK) < U_COMMAND
 *	No two of U_MAP or U_HARDLINK or U_COMMAND
 *	multiple U_MKDIRs, but no mixing of U_MKDIRs with others
 */
TARGETSOURCELIST *Collection_SourceList_AddSource(sourcelistp,
						  sourcep,
						  collectionp)
     TARGETSOURCELIST *sourcelistp;
     TARGETSOURCE *sourcep;
     COLLECTION *collectionp;
{
  register TARGETSOURCE **fp, **tp;
  register TARGETSOURCE *sp;
  register int i;
  register char flag_conflict;
  TARGETSOURCELIST *newsourcelistp;
  int InsertionPoint;
  Boolean FoundInsertionPoint, DuplicateSource;

  if (sourcep == NULL)
    {
      FatalError(E_BADTARGETSOURCE,
		 "Attempt to add NULL source to targetsourcelist.\n");
    }

  if (((TARGETSOURCE_UpdateSpec(sourcep)
	& (U_MAP|U_MAPCOPY|U_MAPLINK|U_MKDIR|U_HARDLINK|U_COMMAND
	   |U_NONVIRGIN|U_COMMANDPATH))
       != TARGETSOURCE_UpdateSpec(sourcep))
      || !(TARGETSOURCE_UpdateSpec(sourcep)
	   & (U_MAP|U_MKDIR|U_HARDLINK|U_COMMAND)))
    {
      FatalError(E_BADSOURCEUPDTSPEC,
		 "Bad update specification %x for source in collection %s.\n",
		 TARGETSOURCE_UpdateSpec(sourcep),
		 COLLECTION_Name(collectionp));
    }

  newsourcelistp = sourcelistp;
  if ((PROGRAM_ErrorNo == E_NULL) && (newsourcelistp == NULL))
    {
      newsourcelistp = (TARGETSOURCELIST *)emalloc(sizeof(TARGETSOURCELIST));
      if (PROGRAM_ErrorNo == E_NULL)
	{
	  TARGETSOURCELIST_NSources(newsourcelistp) = 0;
	  TARGETSOURCELIST_SourceArray(newsourcelistp) = NULL;
	}
    }

  /* locate insertion point for source */
  if (PROGRAM_ErrorNo == E_NULL)  {
    i = 0 ;
    flag_conflict = 0;
    FoundInsertionPoint = FALSE; InsertionPoint = 0;
    DuplicateSource = FALSE;
    while ( !FoundInsertionPoint && !DuplicateSource
	    && (i < TARGETSOURCELIST_NSources(newsourcelistp)) ) {
      sp = TARGETSOURCELIST_Source(newsourcelistp, i);
      if (TARGETSOURCE_UpdateSpec(sourcep) & (U_MAP | U_HARDLINK)) {
	if (TARGETSOURCE_UpdateSpec(sp) & (U_MAP | U_HARDLINK)) {
	  if (TargetSource_Comparator(sourcep, sp) == TRUE) { 
	    DuplicateSource = TRUE; 
	  } else if (TARGETSOURCE_UpdateSpec(sp) & U_MKDIR) {
	    flag_conflict = 1;
	  } else if (TARGETSOURCE_UpdateSpec(sp) & U_COMMAND) {
	    InsertionPoint = i; FoundInsertionPoint = TRUE;
	  }
	} else if (TARGETSOURCE_UpdateSpec(sourcep) & U_MKDIR) {
	  if (TARGETSOURCE_UpdateSpec(sp) & (U_MAP | U_HARDLINK |U_COMMAND)) {
	    flag_conflict = 1;
	  } else if (TargetSource_Comparator(sourcep, sp) == TRUE) {
	     DuplicateSource = TRUE; 
	  }
	} else { /* if (TARGETSOURCE_UpdateSpec(sourcep) & U_COMMAND) */ 
	  if (TARGETSOURCE_UpdateSpec(sp) & U_MKDIR) {
	    flag_conflict = 1;
	  } else if (TARGETSOURCE_UpdateSpec(sp) & U_COMMAND) {
	    if (TargetSource_Comparator(sourcep, sp) == TRUE) {
	      DuplicateSource = TRUE; 
	    }  else {
	      flag_conflict = 1;
	    }
	  }
	}
      }
      if (flag_conflict) {
	TargetDB_ReportUpdateConflict(sourcep, sp, collectionp);
	flag_conflict = 0;
      }
      i++;
    } /* while */

    if (!FoundInsertionPoint) {
      InsertionPoint = TARGETSOURCELIST_NSources(newsourcelistp);
      FoundInsertionPoint = TRUE;
    }
  }

  /* if not a duplicate source, insert source at InsertionPoint */
  if ((PROGRAM_ErrorNo == E_NULL) && !DuplicateSource)
    {
      if (!FoundInsertionPoint)
	{ /* never happens! */
	  FatalError(E_BADTARGETSOURCE,
		     "Attempt to add source failed for collection %s.\n",
		     COLLECTION_Name(collectionp));
	}
      else
	{
	  TARGETSOURCELIST_NSources(newsourcelistp)++;
	  if (TARGETSOURCELIST_NSources(newsourcelistp) == 1)
	    {
	      /* $$$HERE$$$ */
	      TARGETSOURCELIST_SourceArray(newsourcelistp) =
		(TARGETSOURCE **)emalloc(sizeof(TARGETSOURCE *));
	    }
	  else
	    {
	      TARGETSOURCELIST_SourceArray(newsourcelistp) =
		(TARGETSOURCE **)
		  erealloc((void *)TARGETSOURCELIST_SourceArray(newsourcelistp),
			   TARGETSOURCELIST_NSources(newsourcelistp)
			   *sizeof(TARGETSOURCE *));
	      i = TARGETSOURCELIST_NSources(newsourcelistp) - 1;
	      tp = TARGETSOURCELIST_SourceArray(newsourcelistp) + i;
	      fp = tp - 1;
	      while ((PROGRAM_ErrorNo == E_NULL) && (i > InsertionPoint))
		{
		  *tp-- = *fp--, i--;
		}
	    }
	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      TARGETSOURCELIST_Source(newsourcelistp,
				      InsertionPoint) = TargetSource(sourcep);
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? newsourcelistp : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/Collection/RCS/Collection_TargetSource.c,v $ */

