/***********************************************************
        Copyright 1991, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: Collection_CommandTarget.c,v 1.6 1994/10/31 14:42:21 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"


TARGETDB *
Collection_CommandTarget(targetdbp,
			 commandlabel,
			 target,
			 collectionp)
     TARGETDB *targetdbp;
     char *commandlabel;
     char *target;
     COLLECTION *collectionp;
{
  TARGETDB *newtargetdbp;

  TARGETDB *targetdbnodep;
  TARGETSOURCE *targetsourcep;


  if (collectionp == NULL) {
    FatalError(E_NULLCOLLECTION,
	       "NULL collection detected when processing command target.\n");
  }
  if (commandlabel == NULL) {
    FatalError(E_NULLCOMMANDLABEL,
	       "NULL command label detected in collection: %s.\n",
	       COLLECTION_Name(collectionp));
  }
  if (target == NULL) {
    FatalError(E_NULLTARGET,
	       "NULL target specification detected for collection: %s\n",
	       COLLECTION_Name(collectionp));
  }
  /* 
   * Create non-virgin branch in targetdbp to specified target,
   * except that the leaf is not to be marked as nonvirgin. Add source info
   * for leaf node indicating its creation by the command.
   */
  if (PROGRAM_ErrorNo == E_NULL)
    newtargetdbp = Collection_TargetDBCreateCommandPath(targetdbp,
							commandlabel, target,
							collectionp);
  if (PROGRAM_ErrorNo == E_NULL)
    targetdbnodep = TargetDB_LocateNode(newtargetdbp, target, TDB_LOCATE);

  /* add source to targetnodep -- unless it is the root node */
  if (PROGRAM_ErrorNo == E_NULL) {
    if (String_Comparator(TARGETDB_Name(targetdbnodep), "/") == 0) {
      FatalError
	(E_BADCOMMANDTARGET,
	 "Attempt to make command %s create the target directory in collection: %s\n",
	 commandlabel, COLLECTION_Name(collectionp));
    } else {
      targetsourcep = TargetSource_Create(commandlabel,
					  U_COMMAND,
					  COLLECTION_Id(collectionp),
					  S_NULL,
					  U_NULL /* update_spec_old */ ,
					  NULL);
      if (PROGRAM_ErrorNo == E_NULL)
	TARGETDB_SourceList(targetdbnodep) =
	  Collection_SourceList_AddSource
	  (TARGETDB_SourceList(targetdbnodep), targetsourcep, collectionp);
    }

    if (PROGRAM_ErrorNo == E_NULL)
      TargetSource_Free(targetsourcep);
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/Collection/RCS/Collection_CommandTarget.c,v $ */
