/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: depot_getcollectioninfo.c,v 1.5 1994/08/13 04:13:55 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include <stdio.h>

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "Hint.h"
#include "FileSystemImage.h"
#include "Preference.h"
#include "MasterDepotDB.h"
#include "HintService.h"

#include "DepotQuery.h"

static char VersionString[] = "depot_getcollectioninfo: $Revision: 1.5 $ $Date: 1994/08/13 04:13:55 $";
static char *UsageString[] =
{
  "depot_getcollectioninfo targetdir collectionname",
  "depot_getcollectioninfo -help",
};
static unsigned NOptions = sizeof(UsageString)/sizeof(UsageString[0]);

static void Usage(fp)
  FILE *fp;
{
  register char **up;
  register unsigned i;

  (void)fprintf(fp,"%s\n", VersionString);
  (void)fprintf(fp,"%s\n", getversion_libdepot());
  for (i = 0, up = UsageString; i < NOptions; i++, up++)
    { fputs("\t", fp); fputs(*up, fp); fputs("\n", fp); }
}

/* main entry point
 */
main(argc, argv)
    int argc;
    char **argv;
{
  FILE *out = stdout;
  COLLECTION *collectionp;

  if (argc < 2)
    {
      FatalError(E_USAGE, "Error on command line: no arguments\n");
    }
  else if (strcmp(argv[1], "-help") == 0)
    Usage(stdout);
  else if (argc == 3)
    {
      collectionp = DepotQuery_GetCollectionInfo(argv[1], argv[2]);
      if (PROGRAM_ErrorNo == E_NULL)
	{
	  if (collectionp == NULL)
	    {
	      fprintf(out, "No info on collection %s\n", argv[2]);
	    }
	  else
	    {
	      fprintf(out, "Path to collection %s : %s\n",
		      argv[2], COLLECTION_Path(collectionp));
	      if (COLLECTION_HintDB(collectionp) == NULL)
		{
		  fprintf(out,
			  "No hint info for colection %s\n", argv[2]);
		}
	      else
		{
		  fprintf(out,
			  "List of hints for paths under collection %s:\n",
			  argv[2]);
		  (void)HintDB_Write(out, COLLECTION_HintDB(collectionp));
		}
	    }
	}
    }
  else
    {
      FatalError(E_USAGE,
		 "Bad command line option %s\n", argv[1]);
    }

  if (PROGRAM_ErrorNo == E_USAGE)
    Usage(stderr);

  exit(PROGRAM_ErrorNo);
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/cmd/depot_collectioninfo/RCS/depot_getcollectioninfo.c,v $ */

