.\"
.\" $Header: /afs/andrew.cmu.edu/system/src/local/depot2/020/man/man5/RCS/depot.pref.man,v 2.3 1995/04/27 19:00:45 ww0r Exp $
.\" $Source: /afs/andrew.cmu.edu/system/src/local/depot2/020/man/man5/RCS/depot.pref.man,v $
.\"
.\"        Copyright 1991 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH DEPOT.PREF 5 "29 Jun 1993"
.SH NAME
depot.pref \- depot customization instructions
.SH SYNOPSIS
.B [targetdir]/depot/depot.pref
.SH DESCRIPTION
The file
.I depot.pref
contains user-specified values for resources 
which may be used to tailor the behavior of \fBdepot\fR(1).
Resources are specified as strings of the form:
.sp 1
.ce 5
\fIpreferencefunction operand value\fR
or
\fIpreferencefunction value\fR
or
\fIpreferencefunction operand\fR
.sp 1
one on each line, in the \fIdepot.pref\fR file.
.LP
The first form, \fIpreferencefunction operand value\fR, is used to
specify resources which are to be applied on a per collection basis,
per target basis or to a command label. If the resource is to be
applied to a collection, an asterisk (*) may be used in place of the
collection-name to instruct \fBdepot\fR(1) to apply the preference to
all collections.
.LP
The second form, \fIpreferencefunction value\fR, is used for resources
which apply to the \fBdepot\fR(1) program in general.
.LP
The third form, \fIpreferencefunction operand\fR, is used for
resources which apply to a collection or target path without further
modifiers.
.PP
Lines in \fIdepot.pref\fR starting with a # are treated as comments
and are ignored by \fBdepot\fR(1).
.PP
\fBDepot\fR(1) recognizes the following resources:
.PP
.TP 8
command \fIcommandlabel commandname argumentlist\fR specifies the
actual command and list of arguments to be associated with the given
commandlabel. If the commandname does not start with a /, it is
assumed that it is either a file to be installed by \fBdepot\fR(1) or
an executable to be searched for using the PATH environment variable.
As with most  lists in \fBdepot\fR(1), the list of arguments in
\fIargumentlist\fR must be separated commas.
.PP
.TP 8
filter \fI filterlabel filtername argumentlist\fR Specifies the actual
filter and list of arguments to be associated with the given
filterlabel. If the filtername does not start with a /, it is assumed
that it is either a file to be installed by \fBdepot\fR(1) or an
executable to be searched for using the PATH environment
variable. Unlike most lists in \fBdepot\fR(1), the list of arguments
in \fIargumentlist\fR are separated by one or more white spaces
instead of commas.

When the filter is executed, its standard in and standard out will be
directed to the respective input and output files, and the standard
error will go to \fBdepot\fR(1)'s standard error. For the convenience
of filters that need to know the name of the file they're running on,
the symbols \fI%from\fR and \fI%to\fR will be replaced with the
respective from and to paths.

The default filterlabels defined for installing files are \fI copy, link, delete, 
noop,\fR and \fIdefault.\fR
.PP
.TP 8
target.command \fIcommandlabel targetpath\fR
specifies that \fBdepot\fR(1) is to execute the command specified
by the \fIcommandlabel\fR whenever anything is installed into
the given \fItargetpath\fR.
.PP
.TP 8
hintfile \fIcollectionname filename\fR 
specifies a file from which \fBdepot\fR(1) may obtain information
about the date of the last modification of the named collection. By
default, the hintfile used is
\fI[targetdir]/depot/depot.hint\fR. Hintfiles are optional.
.PP
.TP 8
ignore \fIcollectionlist\fR 
specifies a list of collections that should not be installed by
\fBdepot\fR(1).
.PP
.TP 8
collection.installmethod  \fIfilterlabel  collectionlist\fR
specifies the method that \fBdepot\fR(1) will use to install software
from the specified list of collections. If an installmethod has not
been specified for the collection, the default installmethod is
\fIlink\fR.
.PP
.TP 8
target.installmethod  \fIfilterlabel targetpathlist\fR
specifies the method that \fBdepot\fR(1) will use to install the
specified list of files or directories under \fI[targetdir]\fR.  This
preference overrides any collection-specific installmethod preference
for these files.
.PP
.TP 8
target.modemask \fImask targetpathlist\fR
specifies that \fBdepot\fR(1) is to install the paths in
\fItargetpathlist\fR.  If the path specifies a directory,
\fBdepot\fR(1) will install the files under the given path with the
file's mode bits masked by the given \fI mask\fR.
.PP
.TP 8
override \fIcollectionname collectionlist\fR
specifies a list of collections whose software contributions may be
overwritten by the named collection if a conflict occures during
installation. \fBdepot\fR(1) may not function correctly if there are
conflicting overrides.
.PP
.TP 8
path \fIcollectionname collectionpath\fR
specifies the directory where software for the named collection
resides. The collectionpath must be either an absolute pathname or a
path relative to the \fI[targetdir]\fR. For this resource, the use of *
for the collection name is invalid.
.PP
.TP 8
searchpath \fIcollectionname pathlist\fR
specifies a list of directories under which \fBdepot\fR(1) will search
for the named collection if a path has not been specified for the
collection. The pathnames must be either absolute pathnames or paths
relative to the \fItargetdir\fR.  By default, a collection for which a
searchpath has not been specified will be searched for under
\fI[targetdir]/depot\fR.
.PP
.TP 8
target.owner \fIusername targetpathlist\fR
specifies that when \fBdepot\fR(1) installs files into the directories
given by \fItargetpathlist\fR, the files will then be set to the given
username.
.PP
.TP 8
target.group \fIgroupname targetpathlist\fR
specifies that when \fBdepot\fR(1) installs files into the directories
given by \fItargetpathlist\fR, the files will then be set to the given
groupname.
.PP
.TP 8
target.setuid \fIusername targetpathlist\fR
specifies that \fBdepot\fR(1) is to install paths in the given
\fItargetpathlist\fR under \fItargetdir\fR as an executable. This sets
the user-id to that of the given username upon execution.  
.PP
.PP
.TP 8
target.setgid \fIgroupname targetpathlist\fR
specifies that \fBdepot\fR(1) is to install paths in the given
\fItargetpathlist\fR under \fItargetdir\fR as an executable. This sets
the group-id to that of the given groupname upon execution.  
.PP
.TP 8
specialfile \fItargetpathlist\fR
specifies a list of files or directories under \fItargetdir\fR which
should not be updated or modified in any way by \fBdepot\fR(1) during
its operation. Any attempt by a collection to modify a file or
directory tree specified in the \fItargetpathlist\fR will cause
\fBdepot\fR(1) to exit with an error message. \fIspecialfile\fR can
also be used to "hide" files and directories in a collection. 
.PP
.TP 8
usemodtimes true|false
specifies whether or not \fBdepot\fR(1) should use modification time
information when performing installations by copy. This option is not
used on files which  use the default installmethod of \fIlink.\fR. By
default, the value is set to TRUE.
.TP 8
keepcopiedfileattributes true|false
If this option is set to true, \fBdepot\fR(1) will copy a file
exactly. That is, the mode bits, the owner, and the gid will be
copied. If this option is set to be false, then the owner and gid will
be the owner and gid of the process doing the copy. The mode bits will
also be masked by 0777 so that any setuid/setgid bits will be
eliminated. This option is not used on files which use the default
installmethod of \fIlink\fR. By default, the value is set to TRUE.
.TP 8
compresstargetdb true|false
specifies whether or not \fBdepot\fR(1) should compress the target
database. Compression of the target database can save a significant
amount of disk space, but doing so currently requires \fBdepot\fR(1)
to consume more swap space. By default, the value is set to TRUE.
.PP
.TP 8
version \fIcollectionname versionnumber\fR
specifies the version of the named collection which \fBdepot\fR(1) is
to use during installation. If no version is specified, the version
found with the highest version number is used by \fBdepot\fR(1).
Versions for collections are specified by appending a version number
following a delimiter to the collection name. For example, with the
default version delimiter of ~, version 11 of a collection named
\fIfoo\fR would be specified as
.br
.ce 1
foo~11
.PP
.TP 8
versiondelimiter \fIcharacter\fR
specifies the character used to delimit version numbers. The default
delimiter is a tilde (~).
.SH AUTHOR
Sohan C. Ramakrishna-Pillai
.SH "SEE ALSO"
depot(1)
