import './style.scss';

import { useId, useMemo } from 'react';
import { shallow } from 'zustand/shallow';

import { useI18nContext } from '../../../../i18n/i18n-react';
import { Button } from '../../../defguard-ui/components/Layout/Button/Button';
import {
  ButtonSize,
  ButtonStyleVariant,
} from '../../../defguard-ui/components/Layout/Button/types';
import { Modal } from '../../../defguard-ui/components/Layout/modals/Modal/Modal';
import { useAuthStore } from '../../../hooks/store/useAuthStore';
import { externalLink } from '../../../links';
import { RenderMarkdown } from '../RenderMarkdown/RenderMarkdown';
import checkboxUrl from './checkbox.svg?url';
import { useUpgradeLicenseModal } from './store';
import { UpgradeLicenseModalVariant } from './types';

export const UpgradeLicenseModal = () => {
  const isAdmin = useAuthStore((s) => s.user?.is_admin ?? false);
  const isOpen = useUpgradeLicenseModal((s) => s.visible);
  const [close, reset] = useUpgradeLicenseModal((s) => [s.close, s.reset], shallow);

  return (
    <Modal
      isOpen={isOpen && isAdmin}
      onClose={close}
      afterClose={reset}
      id="upgrade-license-modal-content"
      className="upgrade-license-modal"
    >
      <ModalContent />
    </Modal>
  );
};

const ModalContent = () => {
  const variant = useUpgradeLicenseModal((s) => s.modalVariant);
  const { LL } = useI18nContext();
  const localLL = LL.modals.upgradeLicenseModal;
  const close = useUpgradeLicenseModal((s) => s.close, shallow);

  const [title, subtitle] = useMemo(() => {
    switch (variant) {
      case UpgradeLicenseModalVariant.ENTERPRISE_NOTICE:
        return [localLL.enterprise.title(), localLL.enterprise.subTitle()];
      case UpgradeLicenseModalVariant.LICENSE_LIMIT:
        return [localLL.limit.title(), localLL.limit.subTitle()];
    }
  }, [localLL.enterprise, localLL.limit, variant]);

  return (
    <>
      <div className="title">
        <p>{title}</p>
      </div>
      <div className="image-container">
        <DecoratorSvg />
      </div>
      <div
        className="content"
        style={{
          // eslint-disable-next-line @typescript-eslint/ban-ts-comment
          //@ts-expect-error
          '--list-image': `url("${checkboxUrl}")`,
        }}
      >
        <RenderMarkdown content={subtitle} />
        <RenderMarkdown content={localLL.content()} />
      </div>
      <div className="controls">
        <Button
          size={ButtonSize.STANDARD}
          styleVariant={ButtonStyleVariant.STANDARD}
          text={localLL.controls.cancel()}
          onClick={() => close()}
        />
        <a
          target="_blank"
          href={externalLink.defguardPricing}
          rel="noreferrer noreferrer"
        >
          <Button
            onClick={() => {}}
            styleVariant={ButtonStyleVariant.PRIMARY}
            text={localLL.controls.confirm()}
          />
        </a>
      </div>
    </>
  );
};

const DecoratorSvg = () => {
  const id = useId();
  return (
    <svg
      width={1026}
      height={94}
      viewBox="0 0 1026 94"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath={`url(#${id})`}>
        <path
          d="M-41.4429 68.6658L-7.21678 42.4948C-4.1292 40.1339 0.157217 40.1341 3.24462 42.4952L33.624 65.7283C36.3122 67.7841 39.9554 68.0747 42.9355 66.471L43.9095 65.9468C45.9208 64.8644 48.2797 64.6255 50.4672 65.2825L64.7715 69.5791C66.4132 70.0722 68.1646 70.0641 69.8017 69.5559L83.1404 65.415C84.9406 64.8561 86.8744 64.9034 88.6452 65.5495L99.7609 69.6057C101.761 70.3357 103.962 70.2985 105.936 69.5011L111.002 67.4558C112.273 66.9427 113.648 66.7403 115.013 66.8656L140.13 69.1708C140.733 69.2262 141.328 69.3449 141.906 69.5252L152.284 72.761C154.087 73.3232 156.025 73.277 157.8 72.6293L165.908 69.6695C168.112 68.865 170.549 68.9947 172.655 70.0284L181.77 74.5023C185.57 76.3674 190.162 75.194 192.601 71.7344L206.559 51.9386C210.3 46.6336 218.342 47.2176 221.277 53.0075L226.804 63.9105C228.901 68.0483 233.9 69.7808 238.108 67.8288L246.328 64.0159C248.084 63.2016 250.062 63.0024 251.945 63.4503L277.396 69.5063C278.135 69.6821 278.893 69.7593 279.652 69.7362L325.594 68.3339C326.004 68.3214 326.413 68.2796 326.818 68.2087L335.802 66.6343C336.793 66.4607 337.806 66.462 338.796 66.6382L349.289 68.5047C349.803 68.596 350.323 68.6405 350.845 68.6376L361.459 68.5786C362.408 68.5734 363.349 68.4114 364.245 68.0992L369.349 66.3209C372.264 65.305 375.5 65.9277 377.831 67.9529L379.021 68.9875C382.444 71.9628 387.589 71.7725 390.783 68.5525L411.894 47.2707C415.58 43.5554 421.7 43.9596 424.865 48.1273L439.432 67.3093C441.484 70.0112 444.931 71.2564 448.236 70.4895L452.973 69.3904C454.399 69.0593 455.887 69.0976 457.294 69.5014L462.351 70.9524C464.256 71.499 466.292 71.3718 468.114 70.5921L476.604 66.9592C478.324 66.2233 480.236 66.0674 482.053 66.5153L507.006 72.6683C509.263 73.2248 511.649 72.8453 513.622 71.6161L526.655 63.495C529.238 61.8858 532.478 61.7592 535.179 63.162L541.708 66.5537C542.648 67.0424 543.671 67.3532 544.724 67.4704L548.135 67.8501C549.202 67.9689 550.282 67.8871 551.319 67.6089L562.835 64.5192C563.69 64.2899 564.575 64.1937 565.459 64.234L575.011 64.6701C575.563 64.6953 576.116 64.6673 576.663 64.5865L586.545 63.1255C587.126 63.0397 587.713 63.0134 588.299 63.0471L633.983 65.6724C635.773 65.7753 637.545 65.276 639.018 64.2542V64.2542C641.263 62.6965 644.147 62.3884 646.67 63.4368L663.148 70.2825C665.288 71.1716 667.696 71.1605 669.828 70.2519L696.956 58.6892C699.81 57.4729 703.097 57.8854 705.562 59.7692L719.89 70.7205C721.858 72.2248 724.378 72.8086 726.807 72.3229L745.095 68.6658L783.285 55.846C785.149 55.2202 787.172 55.2514 789.016 55.9344L820.931 67.7548C823.249 68.6135 825.825 68.4342 828.002 67.2626L830.447 65.9468C832.459 64.8644 834.817 64.6255 837.005 65.2825L851.309 69.5791C852.951 70.0722 854.702 70.0641 856.339 69.5559L869.678 65.415C871.478 64.8561 873.412 64.9034 875.183 65.5495L883.849 68.7119C887.197 69.9335 890.952 68.9667 893.293 66.28L903.633 54.415C907.254 50.2598 913.792 50.529 917.059 54.9679L925.9 66.9788C926.988 68.4569 928.519 69.5487 930.272 70.095L938.821 72.761C940.625 73.3232 942.563 73.277 944.337 72.6293L952.446 69.6695C954.65 68.865 957.086 68.9947 959.193 70.0284L969.571 75.1225C972.782 76.6982 976.632 76.1255 979.245 73.6836L995.175 58.7953C998.836 55.3734 1004.64 55.7889 1007.77 59.6979L1012.88 66.0668C1015.36 69.1567 1019.63 70.1567 1023.22 68.4898L1032.87 64.0159C1034.62 63.2016 1036.6 63.0024 1038.48 63.4503L1063.93 69.5063C1064.67 69.6821 1065.43 69.7593 1066.19 69.7362L1112.14 68.334C1112.55 68.3214 1112.96 68.2795 1113.37 68.2085L1122.34 66.6346C1123.33 66.4608 1124.34 66.4619 1125.33 66.638L1135.84 68.5049C1136.35 68.5961 1136.87 68.6405 1137.39 68.6376L1148 68.5786C1148.95 68.5734 1149.89 68.4114 1150.78 68.0993L1155.89 66.3209C1158.8 65.305 1162.04 65.9277 1164.37 67.953L1168.54 71.5799C1170.5 73.2849 1173.13 74.0126 1175.69 73.5599L1204.43 68.4766C1205.35 68.3146 1206.29 68.3021 1207.21 68.4397L1227.72 71.5074C1228.79 71.6677 1229.88 71.6242 1230.94 71.3792L1239.51 69.3904C1240.94 69.0593 1242.42 69.0976 1243.83 69.5014L1248.89 70.9525C1250.79 71.499 1252.83 71.3718 1254.65 70.5921L1263.14 66.959C1264.86 66.2232 1266.77 66.0673 1268.59 66.515L1293.55 72.6684C1295.81 73.2248 1298.2 72.8449 1300.17 71.6149L1313.19 63.4968C1315.78 61.8865 1319.02 61.7595 1321.72 63.1627L1328.24 66.5533C1329.19 67.0422 1330.21 67.3531 1331.26 67.4702L1334.68 67.8505C1335.75 67.9691 1336.83 67.8872 1337.87 67.6091L1349.38 64.5192C1350.24 64.2899 1351.12 64.1937 1352.01 64.2341L1361.55 64.67C1362.1 64.6953 1362.65 64.6673 1363.2 64.5864L1373.08 63.1255C1373.66 63.0397 1374.25 63.0134 1374.84 63.0471L1420.52 65.6724C1422.31 65.7753 1424.08 65.276 1425.56 64.2542V64.2542C1427.8 62.6965 1430.68 62.3884 1433.21 63.4368L1449.69 70.2825C1451.83 71.1716 1454.23 71.1605 1456.37 70.2519L1483.49 58.6891C1486.35 57.4729 1489.63 57.8854 1492.1 59.7692L1509.52 73.0871"
          stroke="#0C8CE0"
          strokeWidth={3.44436}
          strokeMiterlimit={10}
          strokeLinecap="round"
        />
        <path
          d="M1509.52 57.8027L1498.84 59.3963C1498.28 59.4786 1497.72 59.507 1497.17 59.4811L1487.7 59.0417C1486.81 59.0004 1485.92 59.0977 1485.06 59.3302L1473.63 62.4159C1472.59 62.6975 1471.5 62.7803 1470.43 62.6602L1467.07 62.2844C1466.01 62.1659 1464.98 61.8521 1464.04 61.3589L1457.6 57.9966C1454.89 56.5808 1451.64 56.7081 1449.05 58.3309L1436.15 66.4111C1434.17 67.6507 1431.77 68.0333 1429.5 67.471L1404.74 61.3295C1402.92 60.8766 1400.99 61.0341 1399.27 61.7779L1390.87 65.391C1389.04 66.179 1386.99 66.3076 1385.08 65.7551L1380.1 64.3195C1378.69 63.9118 1377.2 63.8727 1375.77 64.2059L1371.12 65.288C1367.8 66.0591 1364.34 64.8059 1362.29 62.0902L1347.88 42.9975C1344.71 38.8068 1338.56 38.4002 1334.87 42.1376L1313.97 63.3151C1310.77 66.5551 1305.61 66.7459 1302.18 63.7506L1301.07 62.785C1298.74 60.7451 1295.49 60.1178 1292.56 61.1428L1287.54 62.9016C1286.64 63.2162 1285.7 63.3798 1284.74 63.3855L1274.21 63.4493C1273.69 63.4525 1273.16 63.4073 1272.64 63.3143L1262.24 61.4482C1261.24 61.2695 1260.22 61.268 1259.22 61.4436L1250.31 63.0139C1249.9 63.0854 1249.49 63.1277 1249.08 63.1404L1203.4 64.5478C1202.64 64.5713 1201.88 64.4931 1201.13 64.3153L1175.85 58.2641C1173.96 57.8114 1171.97 58.0122 1170.21 58.834L1159.47 63.8418C1156.46 65.2426 1152.92 64.7939 1150.36 62.6879L1143.77 57.2663C1139.89 54.0806 1134.13 54.8663 1131.25 58.9724L1114.53 82.814C1112.09 86.2921 1107.48 87.4713 1103.67 85.5911L1094.69 81.1627C1092.58 80.1194 1090.13 79.9884 1087.92 80.8002L1079.91 83.7383C1078.12 84.3921 1076.18 84.4385 1074.36 83.8704L1064.09 80.6468C1063.51 80.4646 1062.91 80.3446 1062.3 80.2886L1037.34 77.9862C1035.97 77.8597 1034.58 78.0642 1033.31 78.5826L1028.32 80.6066C1026.34 81.4121 1024.13 81.4498 1022.12 80.7124L1011.12 76.6786C1009.35 76.0259 1007.4 75.9782 1005.59 76.5429L992.383 80.6666C990.739 81.1799 988.979 81.1883 987.33 80.6907L973.148 76.4113C970.95 75.7481 968.578 75.9901 966.56 77.0835L963.429 78.7792C961.702 79.7143 959.708 80.0313 957.777 79.6776L913.768 71.6182C911.78 71.2542 909.984 70.2028 908.693 68.6479L894.717 51.8107C892.493 49.1317 888.875 48.0555 885.549 49.0836L837.635 63.8921C832.643 65.4352 827.437 62.2113 826.595 57.0538L823.946 40.845C822.381 31.2684 808.634 31.1935 806.965 40.7525L803.691 59.5014C802.831 64.431 797.963 67.5911 793.11 66.3713L761.44 58.4117C759.097 57.823 756.615 58.2451 754.599 59.5751L738.644 70.101C735.726 72.0258 731.934 71.9959 729.047 70.0251L717.069 61.8482C713.941 59.713 709.785 59.8722 706.829 62.2404L697.417 69.7824C694.143 72.4055 689.456 72.288 686.318 69.5043L683.069 66.6216C681.048 64.8289 678.303 64.0885 675.655 64.6217L648.348 70.1198C647.212 70.3485 646.134 70.8041 645.179 71.4592L635.317 78.2202C632.187 80.3665 628.02 80.2098 625.059 77.8345L619.401 73.2948C615.878 70.4686 610.771 70.8441 607.699 74.1551L600.681 81.7205C596.203 86.5486 588.183 84.7667 586.17 78.4963L568.961 24.8898C566.287 16.5604 554.336 17.063 552.371 25.5875L544.314 60.543C542.786 67.1687 534.543 69.4934 529.779 64.6419L523.406 58.152C520.749 55.4457 516.633 54.7969 513.272 56.5543L486.233 70.6921C484.828 71.4267 483.247 71.7591 481.666 71.6528L428.977 68.1115C428.114 68.0535 427.264 67.8656 426.456 67.5542L417.697 64.1764C415.69 63.4021 413.465 63.4076 411.461 64.1917L401.046 68.2672C400.012 68.6717 398.91 68.8726 397.8 68.8586L387.173 68.7254C385.318 68.7021 383.52 68.0802 382.047 66.9522L379.229 64.7951C374.989 61.5487 368.805 62.9859 366.325 67.7158V67.7158C362.994 74.0722 353.732 73.9433 350.778 67.403L327.031 14.8258C323.824 7.72609 313.589 8.19484 311.044 15.5579L293.062 67.599C291.354 72.5403 285.673 74.8324 281.015 72.4597L279.596 71.737C276.891 70.3596 273.662 70.5076 271.094 72.1266L268.877 73.5253C265.558 75.6186 261.243 75.2031 258.384 72.515L251.27 65.8246C248.565 63.2814 244.535 62.7578 241.271 64.5255L216.349 78.0202C212.559 80.0722 207.836 79.0068 205.295 75.5266L192.098 57.4562C188.845 53.0018 182.301 52.7118 178.666 56.8608L172.996 63.3345C171.83 64.6655 170.282 65.605 168.563 66.0252L166.781 66.4609C164.599 66.9944 162.295 66.6541 160.36 65.5124L148.81 58.6967C147.23 57.7646 145.394 57.3612 143.569 57.5453L134.338 58.4766C133.15 58.5965 131.95 58.468 130.815 58.0993L120.676 54.8072C119.471 54.4161 118.195 54.2955 116.939 54.454L64.8799 61.0204C62.2118 61.3569 59.5849 60.1451 58.1091 57.897V57.897C55.7307 54.2739 50.676 53.6372 47.4734 56.5574L31.2158 71.3812C27.8964 74.4078 22.808 74.3743 19.5288 71.3041L-8.31991 45.2302C-12.3326 41.4732 -18.7904 42.3869 -21.6033 47.1097L-41.4429 80.4203"
          stroke="#6800ED"
          strokeWidth={3.44436}
          strokeMiterlimit={10}
          strokeLinecap="round"
        />
      </g>
      <defs>
        <clipPath id={id}>
          <rect
            width={1552}
            height={93}
            style={{
              fill: 'var(--surface-nav-bg)',
            }}
            transform="translate(-42 0.5)"
          />
        </clipPath>
      </defs>
    </svg>
  );
};
