/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.util;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.MultipleDataEntry;
import com.sleepycat.db.MultipleEntry;
import com.sleepycat.db.MultipleKeyDataEntry;
import com.sleepycat.db.MultipleRecnoDataEntry;
import com.sleepycat.thrift.TDbt;
import com.sleepycat.thrift.TKeyData;
import java.util.List;

abstract class InputArgs {
    InputArgs() {
    }

    protected MultipleEntry convert(List<TKeyData> list, boolean bl) throws DatabaseException {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Pairs cannot be empty.");
        }
        TKeyData tKeyData = list.get(0);
        if (bl) {
            return this.toRecnoData(list);
        }
        if (!tKeyData.isSetData()) {
            return this.toData(list);
        }
        return this.toKeyData(list);
    }

    private int getKeyDataSize(TKeyData tKeyData) {
        if (!tKeyData.isSetKey()) {
            throw new IllegalArgumentException("Key must be set.");
        }
        int n = this.getTDbtSize(tKeyData.key);
        if (tKeyData.isSetData()) {
            n += this.getTDbtSize(tKeyData.data);
        }
        return n;
    }

    private int getTDbtSize(TDbt tDbt) {
        int n = tDbt.isSetData() ? tDbt.getData().length : 0;
        return n + 8;
    }

    private MultipleEntry toRecnoData(List<TKeyData> list) throws DatabaseException {
        MultipleRecnoDataEntry multipleRecnoDataEntry = this.initEntry(list, new MultipleRecnoDataEntry());
        for (TKeyData tKeyData : list) {
            multipleRecnoDataEntry.append(new DatabaseEntry(tKeyData.key.getData()).getRecordNumber(), tKeyData.isSetData() ? tKeyData.data.getData() : new byte[]{});
        }
        return multipleRecnoDataEntry;
    }

    private MultipleEntry toData(List<TKeyData> list) throws DatabaseException {
        MultipleDataEntry multipleDataEntry = this.initEntry(list, new MultipleDataEntry());
        for (TKeyData tKeyData : list) {
            multipleDataEntry.append(tKeyData.key.getData());
        }
        return multipleDataEntry;
    }

    private MultipleEntry toKeyData(List<TKeyData> list) throws DatabaseException {
        MultipleKeyDataEntry multipleKeyDataEntry = this.initEntry(list, new MultipleKeyDataEntry());
        for (TKeyData tKeyData : list) {
            multipleKeyDataEntry.append(tKeyData.key.getData(), tKeyData.data.getData());
        }
        return multipleKeyDataEntry;
    }

    private <T extends MultipleEntry> T initEntry(List<TKeyData> list, T t) {
        int n = list.stream().mapToInt(this::getKeyDataSize).sum() + 4;
        t.setData(new byte[n]);
        t.setUserBuffer(n, true);
        return t;
    }
}

