/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.handle;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.server.handle.HandleManager;
import com.sleepycat.server.handle.ReadWriteLockable;
import com.sleepycat.server.handle.ResourceKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public abstract class HandleDescriptor<T>
extends ReadWriteLockable {
    private final T handle;
    private final ResourceKey resourceKey;
    private final List<HandleDescriptor> parents;
    private ConcurrentLinkedDeque<HandleDescriptor> children;
    private HandleManager manager;
    private long id;
    private volatile long lastAccessTime;
    private AtomicBoolean closed = new AtomicBoolean(false);

    protected HandleDescriptor(T t, ResourceKey resourceKey, HandleDescriptor ... handleDescriptorArray) {
        this.handle = Objects.requireNonNull(t, "bdbHandle is null.");
        this.resourceKey = resourceKey;
        this.children = new ConcurrentLinkedDeque();
        this.parents = Arrays.stream((Object[])Objects.requireNonNull(handleDescriptorArray, "parents is null.")).filter(handleDescriptor -> handleDescriptor != null).collect(Collectors.toList());
        this.parents.forEach(handleDescriptor -> handleDescriptor.addChild(this));
    }

    public T getHandle() {
        return this.handle;
    }

    protected ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    protected HandleDescriptor[] getParents() {
        return this.parents.toArray(new HandleDescriptor[this.parents.size()]);
    }

    protected final void addChild(HandleDescriptor handleDescriptor) {
        this.children.addFirst(handleDescriptor);
    }

    protected final void removeChild(HandleDescriptor handleDescriptor) {
        this.children.remove(handleDescriptor);
    }

    Collection<HandleDescriptor> getChildren() {
        return this.children;
    }

    public ResourceKey[] resourceOwners() {
        return new ResourceKey[]{this.resourceKey};
    }

    public long getId() {
        return this.id;
    }

    public boolean isExpired(long l, long l2) {
        if (l < this.lastAccessTime) {
            throw new IllegalArgumentException("The handle is accessed in future. Last accessed: " + this.lastAccessTime + ", now: " + l);
        }
        return l - this.lastAccessTime > l2;
    }

    long getLastAccessTime() {
        return this.lastAccessTime;
    }

    HandleDescriptor touch(long l) {
        this.lastAccessTime = l;
        this.parents.forEach(handleDescriptor -> handleDescriptor.touch(l));
        return this;
    }

    void registerManager(HandleManager handleManager, long l) {
        this.manager = handleManager;
        this.id = l;
        this.touch(System.currentTimeMillis());
    }

    DatabaseException close() {
        DatabaseException databaseException;
        block3: {
            databaseException = null;
            if (this.closed.compareAndSet(false, true)) {
                databaseException = this.manager.closeHandles(this.children);
                this.parents.forEach(handleDescriptor -> handleDescriptor.removeChild(this));
                try {
                    this.closeBdbHandle();
                }
                catch (DatabaseException databaseException2) {
                    if (databaseException != null) break block3;
                    databaseException = databaseException2;
                }
            }
        }
        return databaseException;
    }

    boolean isClosed() {
        return this.closed.get();
    }

    protected abstract void closeBdbHandle() throws DatabaseException;

    public String toString() {
        return "HandleDescriptor{id=" + this.id + ", resourceKey=" + this.resourceKey + '}';
    }
}

