/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.config;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class BdbServerCmdOptions {
    private static final String HELP = "-h";
    private static final String VERSION = "-v";
    private static final String CONFIG_FILE = "-config-file";
    private static final String LOG4J_CONFIG = "-log-config";
    private static Map<String, Consumer<BdbServerCmdOptions>> handlers = new HashMap<String, Consumer<BdbServerCmdOptions>>();
    private static Map<String, Function<String, ?>> parsers;
    private Map<String, Object> options = new HashMap<String, Object>();

    private BdbServerCmdOptions() {
        this.options.put(CONFIG_FILE, "bdb.properties");
        this.options.put(LOG4J_CONFIG, "log4j.xml");
    }

    public static BdbServerCmdOptions parse(String[] stringArray) {
        BdbServerCmdOptions bdbServerCmdOptions = new BdbServerCmdOptions();
        bdbServerCmdOptions.parseArgs(stringArray);
        return bdbServerCmdOptions;
    }

    private void parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (handlers.containsKey(stringArray[n])) {
                handlers.get(stringArray[n]).accept(this);
                ++n;
                continue;
            }
            if (parsers.containsKey(stringArray[n])) {
                if (n + 1 < stringArray.length) {
                    Function<String, ?> function = parsers.get(stringArray[n]);
                    this.options.put(stringArray[n], function.apply(stringArray[n + 1]));
                    n += 2;
                    continue;
                }
                System.err.println(stringArray[n] + " requires an argument.\n");
                this.printUsageAndExit();
                continue;
            }
            System.err.println("Unknown option: " + stringArray[n]);
            this.printUsageAndExit();
        }
    }

    private void printVersionAndExit() {
        System.out.println("Oracle Berkeley DB Server 6.2.32");
        System.exit(0);
    }

    private void printUsageAndExit() {
        System.out.println("BdbServer [-v] [-h]\n\t[-config-file <server config file>]\n\t[-log-config <log4j config file>]");
        System.exit(0);
    }

    public String getConfigFile() {
        return (String)this.options.get(CONFIG_FILE);
    }

    public String getLog4jConfig() {
        return (String)this.options.get(LOG4J_CONFIG);
    }

    static {
        handlers.put(HELP, BdbServerCmdOptions::printUsageAndExit);
        handlers.put(VERSION, BdbServerCmdOptions::printVersionAndExit);
        parsers = new HashMap();
        parsers.put(CONFIG_FILE, Function.identity());
        parsers.put(LOG4J_CONFIG, Function.identity());
    }
}

