/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.callbacks;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.Environment;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryMultiKeyCreator;
import com.sleepycat.db.Transaction;
import com.sleepycat.server.handle.DatabaseFileKey;
import com.sleepycat.server.handle.DatabaseKey;
import com.sleepycat.server.util.KeyDataPair;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServerKeyCreator
implements SecondaryMultiKeyCreator {
    private static final String AUX_DB_SUFFIX = "__aux.db";
    private final Environment env;
    private final DatabaseKey secondaryDbKey;
    private Database auxiliaryDb;
    private ThreadLocal<Transaction> operationTxn;
    private ThreadLocal<Map<KeyDataPair, List<DatabaseEntry>>> newKeys;

    public ServerKeyCreator(Environment environment, DatabaseKey databaseKey) throws DatabaseException {
        this.env = environment;
        this.secondaryDbKey = databaseKey;
        this.operationTxn = new ThreadLocal();
        this.newKeys = new ThreadLocal();
    }

    public static DatabaseKey getAuxiliaryDbKey(DatabaseKey databaseKey) throws IOException {
        String string;
        DatabaseFileKey databaseFileKey;
        DatabaseFileKey databaseFileKey2 = databaseKey.getDatabaseFile();
        if (databaseFileKey2.isInMemory()) {
            databaseFileKey = databaseFileKey2;
            string = ServerKeyCreator.getAuxiliaryName(databaseKey.getDatabaseName());
        } else {
            String string2 = ServerKeyCreator.getAuxiliaryName(databaseFileKey2.getCanonicalPath());
            String string3 = ServerKeyCreator.getAuxiliaryName(databaseFileKey2.getRelativePath());
            databaseFileKey = new DatabaseFileKey(new File(string2), string3, false);
            string = databaseKey.getDatabaseName();
        }
        return new DatabaseKey(databaseFileKey, string);
    }

    public static String getAuxiliaryName(String string) {
        return string + AUX_DB_SUFFIX;
    }

    public void openAuxiliaryDb() throws DatabaseException, IOException {
        DatabaseConfig databaseConfig = this.createAuxiliaryDbConfig();
        DatabaseKey databaseKey = ServerKeyCreator.getAuxiliaryDbKey(this.secondaryDbKey);
        DatabaseFileKey databaseFileKey = databaseKey.getDatabaseFile();
        String string = databaseFileKey.isInMemory() ? null : databaseFileKey.getRelativePath();
        this.auxiliaryDb = this.env.openDatabase(this.operationTxn.get(), string, databaseKey.getDatabaseName(), databaseConfig);
    }

    private DatabaseConfig createAuxiliaryDbConfig() {
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setAllowCreate(true);
        databaseConfig.setExternalFileThreshold(0);
        databaseConfig.setSortedDuplicates(true);
        databaseConfig.setTransactional(true);
        databaseConfig.setType(DatabaseType.HASH);
        return databaseConfig;
    }

    public void setTransaction(Transaction transaction) {
        this.operationTxn.set(transaction);
    }

    public void setNewKeys(Map<KeyDataPair, List<DatabaseEntry>> map) {
        this.newKeys.set(map);
    }

    public void close() throws DatabaseException {
        this.auxiliaryDb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSecondaryKeys(SecondaryDatabase secondaryDatabase, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, Set set) throws DatabaseException {
        try (Cursor cursor = null;){
            cursor = this.auxiliaryDb.openCursor(this.operationTxn.get(), null);
            DatabaseEntry databaseEntry3 = this.makeAuxKey(databaseEntry, databaseEntry2);
            KeyDataPair keyDataPair = new KeyDataPair(databaseEntry, databaseEntry2);
            Map<KeyDataPair, List<DatabaseEntry>> map = this.newKeys.get();
            if (map != null && map.containsKey(keyDataPair)) {
                List<DatabaseEntry> list = map.get(keyDataPair);
                this.storeKeys(databaseEntry3, list, cursor);
                set.addAll(list);
            } else {
                set.addAll(this.removeKeys(databaseEntry3, cursor));
            }
        }
    }

    private DatabaseEntry makeAuxKey(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        int n = databaseEntry.getSize() + databaseEntry2.getSize() + 8;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.putInt(databaseEntry.getSize()).put(databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize()).putInt(databaseEntry2.getSize()).put(databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
        return new DatabaseEntry(byteBuffer.array());
    }

    private void storeKeys(DatabaseEntry databaseEntry, List<DatabaseEntry> list, Cursor cursor) throws DatabaseException {
        for (DatabaseEntry databaseEntry2 : list) {
            cursor.putNoDupData(databaseEntry, databaseEntry2);
        }
    }

    private List<DatabaseEntry> removeKeys(DatabaseEntry databaseEntry, Cursor cursor) throws DatabaseException {
        LinkedList<DatabaseEntry> linkedList = new LinkedList<DatabaseEntry>();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        OperationStatus operationStatus = cursor.getSearchKey(databaseEntry, databaseEntry2, null);
        while (operationStatus == OperationStatus.SUCCESS) {
            linkedList.add(databaseEntry2);
            cursor.delete();
            databaseEntry2 = new DatabaseEntry();
            operationStatus = cursor.getNextDup(databaseEntry, databaseEntry2, null);
        }
        return linkedList;
    }
}

