/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;
import java.math.BigDecimal;

public class SortedBigDecimalBinding
extends TupleBinding<BigDecimal> {
    @Override
    public BigDecimal entryToObject(TupleInput tupleInput) {
        return tupleInput.readSortedBigDecimal();
    }

    @Override
    public void objectToEntry(BigDecimal bigDecimal, TupleOutput tupleOutput) {
        tupleOutput.writeSortedBigDecimal(bigDecimal);
    }

    @Override
    protected TupleOutput getTupleOutput(BigDecimal bigDecimal) {
        return SortedBigDecimalBinding.sizedOutput(bigDecimal);
    }

    public static BigDecimal entryToBigDecimal(SDatabaseEntry sDatabaseEntry) {
        return SortedBigDecimalBinding.entryToInput(sDatabaseEntry).readSortedBigDecimal();
    }

    public static void bigDecimalToEntry(BigDecimal bigDecimal, SDatabaseEntry sDatabaseEntry) {
        SortedBigDecimalBinding.outputToEntry(SortedBigDecimalBinding.sizedOutput(bigDecimal).writeSortedBigDecimal(bigDecimal), sDatabaseEntry);
    }

    private static TupleOutput sizedOutput(BigDecimal bigDecimal) {
        int n = TupleOutput.getSortedBigDecimalMaxByteLength(bigDecimal);
        return new TupleOutput(new byte[n]);
    }
}

