/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.RemoteCallHelper;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SJoinConfig;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.thrift.BdbService;
import com.sleepycat.thrift.TDbt;
import com.sleepycat.thrift.TGetResult;
import com.sleepycat.thrift.TJoinCursor;
import com.sleepycat.thrift.TJoinCursorGetConfig;
import com.sleepycat.thrift.TKeyData;
import com.sleepycat.thrift.TOperationStatus;

public class SJoinCursor
implements RemoteCallHelper,
AutoCloseable {
    private final TJoinCursor joinCursor;
    private final SJoinConfig config;
    private final SDatabase database;
    private final BdbService.Client client;

    SJoinCursor(TJoinCursor tJoinCursor, SJoinConfig sJoinConfig, SDatabase sDatabase, BdbService.Client client) {
        this.joinCursor = tJoinCursor;
        this.config = sJoinConfig;
        this.database = sDatabase;
        this.client = client;
    }

    @Override
    public void close() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.closeJoinCursorHandle(this.joinCursor);
            return null;
        });
    }

    public SJoinConfig getConfig() {
        return this.config;
    }

    public SDatabase getDatabase() {
        return this.database;
    }

    public SOperationStatus getNext(SDatabaseEntry sDatabaseEntry, SLockMode sLockMode) throws SDatabaseException {
        return this.getNext(sDatabaseEntry, null, sLockMode);
    }

    public SOperationStatus getNext(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SLockMode sLockMode) throws SDatabaseException {
        return this.remoteCall(() -> {
            TJoinCursorGetConfig tJoinCursorGetConfig = new TJoinCursorGetConfig();
            this.setConfig(tJoinCursorGetConfig, sLockMode);
            TKeyData tKeyData = new TKeyData().setKey((TDbt)sDatabaseEntry.getThriftObj());
            if (sDatabaseEntry2 != null) {
                tKeyData.setData((TDbt)sDatabaseEntry2.getThriftObj());
            }
            tJoinCursorGetConfig.setPair(tKeyData);
            TGetResult tGetResult = this.client.joinCursorGet(this.joinCursor, tJoinCursorGetConfig);
            if (tGetResult.status == TOperationStatus.SUCCESS) {
                TKeyData tKeyData2 = (TKeyData)tGetResult.pairs.get(0);
                sDatabaseEntry.setDataFromTDbt(tKeyData2.key);
                if (sDatabaseEntry2 != null) {
                    sDatabaseEntry2.setDataFromTDbt(tKeyData2.data);
                }
            }
            return SOperationStatus.toBdb(tGetResult.status);
        });
    }

    private TJoinCursorGetConfig setConfig(TJoinCursorGetConfig tJoinCursorGetConfig, SLockMode sLockMode) {
        if (sLockMode == SLockMode.RMW) {
            tJoinCursorGetConfig.setRmw(true);
        } else if (sLockMode == SLockMode.READ_UNCOMMITTED) {
            tJoinCursorGetConfig.setReadUncommitted(true);
        }
        return tJoinCursorGetConfig;
    }
}

