/* --------------------------------------------------------------------------
 * MAME GameList - Save only
 * -------------------------------------------------------------------------- */

/* --- Standard includes --- */

#include <stdio.h>
#include <string.h>


/* --- My includes --- */

#include "../type.h"
#include "../token.h"


/* --- External structures --- */

extern const struct datlib_token datlib_tokens[];


/* --- Is debugging enabled? --- */

extern int datlib_debug;


/* --- Identification --- */

int identify_mame_gamelist(struct dat *dat)
{
	return(0);
}


/* --- Load --- */

int load_mame_gamelist(struct dat *dat)
{
	return(0);
}


/* --- Specify --- */

int specify_mame_gamelist(struct dat *dat)
{
	if (strcmp(dat->options->save_format, "gamelist") &&
		strcmp(dat->options->save_format, "gl"))
	{
		return(0);
	}
	else
	{
		dat->options->options|=OPTION_KEEP_FULL_DETAILS;
		return(1);
	}
}


/* --- Save --- */

int save_mame_gamelist(struct dat *dat)
{
	char st[MAX_STRING_LENGTH];

	struct game_idx *curr_game_idx;
	struct game *curr_game, *tmp_game;
	//struct dipswitch *curr_dipswitch;

	//int screen_flip;
	int i, j, working_clone, errflg=0;


	/* --- Header --- */

	strcpy(st, dat->name);
	if (strchr(st, '.'))
		*strrchr(st, '.')='\0';

	fprintf(dat->out, "This is the complete list of games supported by %s\n\n", st);

	fprintf(dat->out, "This list is designed to copy the format of the old gamelist.txt but variations\n");
	fprintf(dat->out, "may occur. Specifically, the screen flipping column is not yet supported.\n");
	fprintf(dat->out, "Explanatory text has been copied from the original file generated by MAME.\n\n");

	fprintf(dat->out, "This list is generated automatically and is not 100%% accurate. DatLib extracts\n");
	fprintf(dat->out, "information from -listxml and errors may be introduced during this process.\n\n");

	fprintf(dat->out, "Generated using DatUtil (available from http://www.logiqx.com/):\n");
	fprintf(dat->out, "datutil -f gamelist \"%s\"\n\n", dat->name);

	fprintf(dat->out, "Here are the meanings of the columns:\n\n");

	fprintf(dat->out, "Working\n");
	fprintf(dat->out, "=======\n");
  	fprintf(dat->out, "  NO: Emulation is still in progress; the game does not work correctly. This\n");
  	fprintf(dat->out, "  means anything from major problems to a black screen.\n\n");

	fprintf(dat->out, "Correct Colors\n");
	fprintf(dat->out, "==============\n");
    	fprintf(dat->out, "    YES: Colors should be identical to the original.\n");
  	fprintf(dat->out, "  CLOSE: Colors are nearly correct.\n");
     	fprintf(dat->out, "     NO: Colors are completely wrong. \n\n");
  
  	fprintf(dat->out, "  Note: In some cases, the color PROMs for some games are not yet available.\n");
  	fprintf(dat->out, "  This causes a NO GOOD DUMP KNOWN message on startup (and, of course, the game\n");
  	fprintf(dat->out, "  has wrong colors). The game will still say YES in this column, however,\n");
  	fprintf(dat->out, "  because the code to handle the color PROMs has been added to the driver. When\n");
  	fprintf(dat->out, "  the PROMs are available, the colors will be correct.\n\n");

	fprintf(dat->out, "Sound\n");
	fprintf(dat->out, "=====\n");
  	fprintf(dat->out, "  PARTIAL: Sound support is incomplete or not entirely accurate. \n\n");

  	fprintf(dat->out, "  Note: Some original games contain analog sound circuitry, which is difficult\n");
  	fprintf(dat->out, "  to emulate. Therefore, these emulated sounds may be significantly different.\n\n");

	fprintf(dat->out, "Screen Flip\n");
	fprintf(dat->out, "===========\n");
  	fprintf(dat->out, "  Many games were offered in cocktail-table models, allowing two players to sit\n");
  	fprintf(dat->out, "  across from each other; the game's image flips 180 degrees for each player's\n");
  	fprintf(dat->out, "  turn. Some games also have a \"Flip Screen\" DIP switch setting to turn the\n");
  	fprintf(dat->out, "  picture (particularly useful with vertical games).\n");
  	fprintf(dat->out, "  In many cases, this feature has not yet been emulated.\n\n");

	fprintf(dat->out, "Internal Name\n");
	fprintf(dat->out, "=============\n");
  	fprintf(dat->out, "  This is the unique name that must be used when running the game from a\n");
  	fprintf(dat->out, "  command line.\n\n");

  	fprintf(dat->out, "  Note: Each game's ROM set must be placed in the ROM path, either in a .zip\n");
  	fprintf(dat->out, "  file or in a subdirectory with the game's Internal Name. The former is\n");
  	fprintf(dat->out, "  suggested, because the files will be identified by their CRC instead of\n");
  	fprintf(dat->out, "  requiring specific names.\n\n");

	fprintf(dat->out, "+----------------------------------+-------+-------+-------+-------+----------+\n");
	fprintf(dat->out, "|                                  |       |Correct|       |Screen | Internal |\n");
	fprintf(dat->out, "| Game Name                        |Working|Colors | Sound | Flip  |   Name   |\n");
	fprintf(dat->out, "+----------------------------------+-------+-------+-------+-------+----------+\n");


	/* --- List games --- */

	for (i=0, curr_game_idx=dat->game_description_idx; i<dat->num_games; i++, curr_game_idx++)
	{
		curr_game=curr_game_idx->game;

		if (!(curr_game->game_flags & FLAG_RESOURCE_NAME) && !curr_game->game_cloneof)
		{
			/* --- Game Name --- */

			strncpy(st, curr_game->description, 32);
			st[32]='\0';
			fprintf(dat->out, "| %s ", st);
			for (j=strlen(st); j<32; j++)
				fprintf(dat->out, " ");
			fprintf(dat->out, "|");

			/* --- Working --- */

			if (curr_game->drivers && curr_game->drivers->emulation)
			{
				if (!strcmp(curr_game->drivers->emulation, "good"))
				{
					fprintf(dat->out, "  Yes  |");
				}
				else
				{
					for (working_clone=0, j=0, tmp_game=dat->games; j<dat->num_games; j++, tmp_game++)
					{
						if (tmp_game->game_cloneof==curr_game)
							if (tmp_game->drivers && tmp_game->drivers->emulation)
								if (!strcmp(tmp_game->drivers->emulation, "good"))
									working_clone++;
					}

					if (working_clone)
						fprintf(dat->out, " No(1) |");
					else
						fprintf(dat->out, "   No  |");
				}
			}
			else
			{
				fprintf(dat->out, "  ???  |");
			}

			/* --- Correct Colors --- */

			if (curr_game->drivers && curr_game->drivers->color)
			{
				if (!strcmp(curr_game->drivers->color, "good"))
					fprintf(dat->out, "  Yes  |");
				else if (!strcmp(curr_game->drivers->color, "imperfect"))
					fprintf(dat->out, " Close |");
				else
					fprintf(dat->out, "   No  |");
			}
			else
			{
				fprintf(dat->out, "  ???  |");
			}

			/* --- Sound --- */

			if (curr_game->drivers && curr_game->drivers->sound)
			{
				if (!strcmp(curr_game->drivers->sound, "good"))
				{
					if (curr_game->samples)
						fprintf(dat->out, " Yes(2)|");
					else
						fprintf(dat->out, "  Yes  |");
				}
				else if (!strcmp(curr_game->drivers->sound, "imperfect"))
				{
					if (curr_game->samples)
						fprintf(dat->out, "Part(2)|");
					else
						fprintf(dat->out, "Partial|");
				}
				else
				{
					fprintf(dat->out, "   No  |");
				}
			}
			else
			{
				fprintf(dat->out, "  ???  |");
			}

			/* --- Screen Flip --- */

			if (curr_game->drivers && curr_game->drivers->cocktail)
			{
				if (!strcmp(curr_game->drivers->cocktail, "preliminary"))
					fprintf(dat->out, "   No  |");
				else
					fprintf(dat->out, "  Yes  |");
			}
			else
			{
				if (dat->driver_flags)
					fprintf(dat->out, "  Yes  |");
				else
					fprintf(dat->out, "  ???  |");
			}

			/*if (curr_game->dipswitches)
			{
				screen_flip=0;

				for (j=0, curr_dipswitch=curr_game->dipswitches; j<curr_game->num_dipswitches; j++, curr_dipswitch++)
				{
					if (!strcmp(curr_dipswitch->name, "Flip Screen"))
						screen_flip++;
				}

				if (screen_flip)
					fprintf(dat->out, "  Yes  |");
				else
					fprintf(dat->out, "   No  |");
			}
			else
			{
				if (dat->dipswitch_flags)
					fprintf(dat->out, "   No  |");
				else
					fprintf(dat->out, "  ???  |");
			}*/

			/* --- Internal Name --- */

			strncpy(st, curr_game->name, 8);
			st[8]='\0';
			fprintf(dat->out, " %s ", st);
			for (j=strlen(st); j<8; j++)
				fprintf(dat->out, " ");

			/* --- End of line --- */

			fprintf(dat->out, "|\n");
		}
	}


	/* --- Footer --- */

	fprintf(dat->out, "+----------------------------------+-------+-------+-------+-------+----------+\n\n");
	
	fprintf(dat->out, "(1) There are variants of the game (usually bootlegs) that work correctly\n");
	fprintf(dat->out, "(2) Needs samples provided separately\n\n\n");

	fprintf(dat->out, "%d parent, %d clone, and %d BIOS sets processed\n", dat->num_parents+dat->num_others, dat->num_clones, dat->num_resources);


	/* --- User only wants the names so don't report other details that are not saved! --- */

	dat->emulator_saved=0xff;
	dat->header_saved=0xffff;
	dat->clrmamepro_saved=0xff;
	dat->romcenter_saved=0xffff;
	dat->game_saved=0xffff;
	dat->release_saved=0xff;
	dat->biosset_saved=0xff;
	dat->rom_saved=0xffff;
	dat->disk_saved=0xff;
	dat->sample_saved=0xff;
	dat->chip_saved=0xff;
	dat->video_saved=0xff;
	dat->display_saved=0xff;
	dat->sound_saved=0xff;
	dat->input_saved=0xff;
	dat->control_saved=0xff;
	dat->dipswitch_saved=0xff;
	dat->dipvalue_saved=0xff;
	dat->driver_saved=0xff;

	return(errflg);
}

