/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : z1lpf.h
|
| Object      : DSPKitZ1LowPassFilter
|
| Description : DSPKitZ1LowPassFilter
|
| (c) Richard Kent 1996
|
| $Id: z1lpf.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_Z1LOWPASSFILTER_H_
#define _DSPKIT_Z1LOWPASSFILTER_H_

#include "processo.h"

class DSPKitZ1LowPassFilter : public DSPKitProcessor
{
  public:

    DSPKitZ1LowPassFilter ();
    int setInput (DSPKitProcessor *ip);
    void setG (double newG);
    int getSample (double &outputSample);
    double getG () const;

  protected:

    double buf;
    double g;
};

inline void DSPKitZ1LowPassFilter::setG (double newG)
{
  g = newG;
}

inline double DSPKitZ1LowPassFilter::getG () const
{
  return g;
}

#endif

/***************************************************************************/
