/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : z1lpf.cc
|
| Object      : DSPKitZ1LowPassFilter
|
| Description : DSPKitZ1LowPassFilter
|
| (c) Richard Kent 1996
|
| $Id: z1lpf.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char z1lpf_cc [] = "$Id: z1lpf.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "z1lpf.h"

DSPKitZ1LowPassFilter::DSPKitZ1LowPassFilter ()
{
  buf = 0.0;
  g   = 0.0;
}

int DSPKitZ1LowPassFilter::setInput (DSPKitProcessor *ip)
{
  DSPKitProcessor::setInput (ip);
  buf = 0.0;
  return 0;
}

int DSPKitZ1LowPassFilter::getSample (double &outputSample)
{
  double inputSample;
  if (!input->getSample (inputSample)) return 0;
  outputSample = inputSample + buf * g;
  buf = inputSample;
  return 1;
}

/***************************************************************************/
