/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : sumavg.cc
|
| Object      : DSPKitSumAvg
|
| Description : DSPKitSumAvg
|
| (c) Richard Kent 1996
|
| $Id: sumavg.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char sumavg_cc [] = "$Id: sumavg.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "sumavg.h"

int DSPKitSumAvg::setInput (DSPKitProcessor *ip)
{
  if (DSPKitProcessor::setInput (ip) != 0) return -1;
  inputList [0] = input;
  inputCount = 1;
  return 0;
}

int DSPKitSumAvg::addInput (DSPKitProcessor *ip)
{
  ip->setOutput(this);
  if (inputCount >= SUMAVGMAXINPUTS) return -1;
  inputList [inputCount++] = ip;
  return 0;
}

int DSPKitSumAvg::getSample (double &outputSample)
{
  int   i;
  int   ok;
  int   success;
  double inputSample;

  outputSample = 0.0;
  success      = 0;

  for (i=0,ok=0; i<inputCount; i++)
  {
    if (inputList [i]->getSample (inputSample))
    {
      outputSample += inputSample;
      success++;
      ok = 1;
    }
  }
  
  if (ok) outputSample = outputSample / success;
  return ok;
}

/***************************************************************************/
