/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : resonato.h
|
| Object      : DSPKitResonator
|
| Description : DSPKitResonator
|
| (c) Richard Kent 1996
|
| $Id: resonato.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_RESONATOR_H_
#define _DSPKIT_RESONATOR_H_

#include "processo.h"

typedef struct DBBuffer
{
  double y1;
  double y2;

} DBBuffer;

class DSPKitResonator : public DSPKitProcessor
{
  public:

    int setInput (DSPKitProcessor *ip);
    void setCenterFreqAndBW (double f,double bw);
    int getSample (double &outputSample);
    
  protected:

    double   centerFreq;
    double   bandwidth;
    double   C;
    double   a0;
    double   b1;
    double   b2;
    DBBuffer chBuf;
};

#endif

/***************************************************************************/
