/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : mult.cc
|
| Object      : DSPKitMult
|
| Description : DSPKitMult
|
| (c) Richard Kent 1996
|
| $Id: mult.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char mult_cc [] = "$Id: mult.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "mult.h"

int DSPKitMult::setInput (DSPKitProcessor *ip)
{
  multInput = 0;
  return DSPKitProcessor::setInput (ip);
}

void DSPKitMult::setMultInput (DSPKitProcessor *mip)
{
  multInput = mip;
  multInput->setOutput (this);
}

int DSPKitMult::getSample (double &outputSample)
{
  double multSample;

  outputSample = 0.0;
  if (input->getSample (outputSample) == 0) return 0;
  if (!multInput || multInput->getSample (multSample) == 0) return 0;
  outputSample *= multSample;
  return 1;
}

/***************************************************************************/
