/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : limiter.cc
|
| Object      : DSPKitLimiter
|
| Description : DSPKitLimiter
|
| (c) Richard Kent 1996
|
| $Id: limiter.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char limiter_cc [] = "$Id: limiter.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "limiter.h"

void DSPKitLimiter::scaleBuffer ()
{
  double scale;
  double scale1;
  double scale2;
  double scaleIncrement;
  int i;
  
  i = writeIndex;

  if (absMax1 <= threshold && absMax2 <= threshold) return;

  if (absMax1 > threshold)
    scale1 = threshold / absMax1;
  else
    scale1 = 1.0;

  if (absMax2 > threshold)
    scale2 = threshold / absMax2;
  else
    scale2 = 1.0;

  scaleIncrement = (scale2 - scale1) / inputBufSize;

  scale = scale1;
  
  while (i != processIndex)
  {
    sampleBuffer [i] *= scale;
    i++;
    i %= bufSize;
    if (i == 0) scale += scaleIncrement;
  }
}

/***************************************************************************/
